/*
 *  Copyright (c) Northwoods Software Corporation, 1998-2008. All Rights
 *  Reserved.
 *
 *  Restricted Rights: Use, duplication, or disclosure by the U.S.
 *  Government is subject to restrictions as set forth in subparagraph
 *  (c) (1) (ii) of DFARS 252.227-7013, or in FAR 52.227-19, or in FAR
 *  52.227-14 Alt. III, as applicable.
 *
 */
package com.nwoods.jgo.examples.demo1;

import java.awt.*;
import java.awt.event.*;
import java.awt.dnd.*;
import java.awt.datatransfer.*;
import javax.swing.*;
import com.nwoods.jgo.*;

public class Demo1List extends JList
    implements DragSourceListener, DragGestureListener
{
  public Demo1List() {
    myDragSource = new DragSource();
    myRecognizer = myDragSource.createDefaultDragGestureRecognizer(
                      this, DnDConstants.ACTION_COPY_OR_MOVE, this);
    // if the user double-clicks on a list item, execute the item's action
    // which will presumably create something in the main view
    addMouseListener(new MouseAdapter() {
      public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
          int index = locationToIndex(e.getPoint());
          AppAction item = (AppAction)getModel().getElementAt(index);
          item.actionPerformed(null);
        }
      }
    });
  }

  // Users can drag an item from the list to drop it on the main
  // view, thereby invoking the action.  Represent the item selected
  // for the drag-and-drop transfer by using a StringSelection.
  // The main view will interpret the string and determine the
  // action to perform.
  public void dragGestureRecognized(DragGestureEvent e)
  {
    AppAction item = (AppAction)getSelectedValue();
    if (item != null) {
      StringSelection sel = new StringSelection(item.toString());
      e.startDrag(DragSource.DefaultCopyDrop, sel, this);
    }
  }

  public void dragDropEnd(DragSourceDropEvent e) {}
  public void dragEnter(DragSourceDragEvent e) {}
  public void dragExit(DragSourceEvent e) {}
  public void dragOver(DragSourceDragEvent e) {}
  public void dropActionChanged(DragSourceDragEvent e) {}

  private DragSource myDragSource;
  private DragGestureRecognizer myRecognizer;
}
