/*
 *  Copyright (c) Northwoods Software Corporation, 1998-2008. All Rights
 *  Reserved.
 *
 *  Restricted Rights: Use, duplication, or disclosure by the U.S.
 *  Government is subject to restrictions as set forth in subparagraph
 *  (c) (1) (ii) of DFARS 252.227-7013, or in FAR 52.227-19, or in FAR
 *  52.227-14 Alt. III, as applicable.
 *
 */

package com.nwoods.jgo.examples.demo1;

import java.awt.*;
import com.nwoods.jgo.*;

public class Demo1RoundRect extends JGoRoundRect
{
  public Demo1RoundRect(Point loc, Dimension size, Dimension arc)
  {
    super(loc, size, arc);
    updateFill();
  }

  public Demo1RoundRect()
  {
    super();
    updateFill();
  }

  // make sure there's a color gradient going from the top-left to the
  // bottom right of the rectangle, no matter where the rectangle is or
  // how big it is.
  public void geometryChange(Rectangle prevRect)
  {
    super.geometryChange(prevRect);
    updateFill();
  }

  // do resizing continuously instead of having the user manipulate an
  // XOR'd bounding rectangle
  public Rectangle handleResize(Graphics2D g, JGoView view,
                                Rectangle prevRect, Point newPoint,
                                int whichHandle, int event,
                                int minWidth, int minHeight)
  {
    Rectangle newRect = super.handleResize(g, view, prevRect, newPoint,
                                  whichHandle, event, minWidth, minHeight);
    // resize continuously (default only does setBoundingRect on MouseUp)
    if (event == JGoView.EventMouseMove)
      setBoundingRect(newRect);
    // don't draw XOR resize rectangle
    return null;
  }

  public void updateFill()
  {
    Rectangle rect = getBoundingRect();
    if (getBrush() != null && getBrush().getStyle() == JGoBrush.SOLID){
        setBrush(new JGoBrush(getBrush().getPaint()));
        return;
    }
    setBrush(new JGoBrush(new GradientPaint(rect.x, rect.y, Color.magenta,
                                            rect.x + rect.width, rect.y + rect.height, Color.blue)));
  }

  public String getToolTipText()
  {
    if (getBrush() == null)
      return "this doesn't have any brush filling in the inside";
    else if (getBrush().getPaint() instanceof GradientPaint)
      return "this is filled with a color gradient";
    else
      return "this is filled with a solid color";
  }

  public void SVGWriteObject(DomDoc svgDoc, DomElement jGoElementGroup)
  {
    // Add Demo1RoundRect element
    DomElement jGoSampleNode = svgDoc.createJGoClassElement("com.nwoods.jgo.examples.demo1.Demo1RoundRect", jGoElementGroup);
    // Have superclass add to the JGoObject group
    super.SVGWriteObject(svgDoc, jGoElementGroup);
  }

  public DomNode SVGReadObject(DomDoc svgDoc, JGoDocument jGoDoc, DomElement svgElement, DomElement jGoChildElement)
  {
    if (jGoChildElement != null) {
      // This is a Demo1RoundRect element
      super.SVGReadObject(svgDoc, jGoDoc, svgElement,
                          jGoChildElement.getNextSiblingJGoClassElement());
      updateFill();
    }
    return svgElement.getNextSibling();
  }

  public void SVGUpdateReference(String attr, Object referencedObject)
  {
    if (!attr.equals("drawablebrush"))
      super.SVGUpdateReference(attr, referencedObject);
  }
}
