/*
 *  Copyright (c) Northwoods Software Corporation, 1998-2008. All Rights
 *  Reserved.
 *
 *  Restricted Rights: Use, duplication, or disclosure by the U.S.
 *  Government is subject to restrictions as set forth in subparagraph
 *  (c) (1) (ii) of DFARS 252.227-7013, or in FAR 52.227-19, or in FAR
 *  52.227-14 Alt. III, as applicable.
 *
 */

package com.nwoods.jgo.examples.demo1;

import java.awt.*;
import java.awt.image.*;
import javax.swing.*;
import com.nwoods.jgo.*;

public class HtmlText extends JGoObject
{
  public HtmlText() {}

  public JGoObject copyObject(JGoCopyEnvironment env)
  {
    HtmlText newobj = (HtmlText)super.copyObject(env);
    if (newobj != null) {
      newobj.myString = myString;
    }
    return newobj;
  }
  
  /**
   * Set the text to be displayed.
   *
   * @param str the text string to be displayed.
   */
  public void setText(String str)
  {
    String oldText = myString;
    if (!oldText.equals(str)) {
      myString = str;
      myEditorImage = null;
      update(ChangedText, 0, oldText);
    }
  }

  /**
   * Return the text that is currently being displayed.
   *
   * @return the current text string.
   */
  public String getText()
  {
    return myString;
  }

  protected void geometryChange(Rectangle prevRect)
  {
    Rectangle rect = getBoundingRect();
    if (rect.width != prevRect.width ||
        rect.height != prevRect.height) {
      myEditorImage = null;
    }
    super.geometryChange(prevRect);
  }
  
  class JGoEditorPane extends JEditorPane
  {
    JGoEditorPane(String t, String s) { super(t, s); }
    public void scrollRectToVisible(Rectangle r) {}
  }

  public void paint(Graphics2D g, JGoView view)
  {
    if (myEditorPane == null) {
      myEditorPane = new JGoEditorPane("text/html", getText());
      myEditorPane.setEditable(false);
      myEditorPane.setBounds(0, 0, 0, 0);
      myEditorPane.setVisible(false);
      view.setLayout(null);
      view.add(myEditorPane);
    }
    int graphicsImageType = g.getDeviceConfiguration().getDevice().getType();
    boolean printing = view.isPrinting();
    if (myEditorImage == null || myEditorImageType != graphicsImageType) {
      int w = getWidth();
      int h = getHeight();
      if (w <= 0 || h <= 0) return;
      myEditorPane.setBounds(0, 0, w, h);
      double bw = w;
      double bh = h;
      if (printing) {
        bw *= 300; bw /= 72;  // ?? assume 300 dpi
        bh *= 300; bh /= 72;
      }
      myEditorPane.setText(getText());
      myEditorImage = g.getDeviceConfiguration().createCompatibleImage((int)bw, (int)bh);
      myEditorImageType = graphicsImageType;
      Graphics2D g2 = myEditorImage.createGraphics();
      if (printing) {
        g2.scale(bw/w, bh/h);
      }
      myEditorPane.paint(g2);
      g2.dispose();
    }
    Rectangle rect = getBoundingRect();
    g.drawImage(myEditorImage, rect.x, rect.y, rect.width, rect.height, null);
  }

  public void copyNewValueForRedo(JGoDocumentChangedEdit e)
  {
    switch (e.getFlags()) {
      case ChangedText:
        e.setNewValue(getText());
        return;
      default:
        super.copyNewValueForRedo(e);
        return;
    }
  }

  public void changeValue(JGoDocumentChangedEdit e, boolean undo)
  {
    switch (e.getFlags()) {
      case ChangedText:
        setText((String)e.getValue(undo));
        return;
      default:
        super.changeValue(e, undo);
        return;
    }
  }

  /** a CHANGED event hint: the text string has changed */
  public static final int ChangedText = 2501;

  static JEditorPane myEditorPane = null;

  private String myString = "";
  transient BufferedImage myEditorImage = null;
  transient int myEditorImageType = 0;
}
