/*
 *  Copyright (c) Northwoods Software Corporation, 1998-2008. All Rights
 *  Reserved.
 *
 *  Restricted Rights: Use, duplication, or disclosure by the U.S.
 *  Government is subject to restrictions as set forth in subparagraph
 *  (c) (1) (ii) of DFARS 252.227-7013, or in FAR 52.227-19, or in FAR
 *  52.227-14 Alt. III, as applicable.
 *
 */

package com.nwoods.jgo.examples.demo1;

import java.awt.*;
import javax.swing.*;
import java.awt.event.*;
import com.nwoods.jgo.JGoImage;
import java.net.URL;

public class ImagePropsDialog extends JDialog {
  JPanel panel1 = new JPanel();
  javax.swing.JButton OKButton = new javax.swing.JButton();
  javax.swing.JButton CancelButton = new javax.swing.JButton();
  javax.swing.JLabel label1 = new javax.swing.JLabel();
  javax.swing.JTextField heightField = new javax.swing.JTextField();
  javax.swing.JTextField xField = new javax.swing.JTextField();
  javax.swing.JLabel label2 = new javax.swing.JLabel();
  javax.swing.JTextField yField = new javax.swing.JTextField();
  javax.swing.JLabel label3 = new javax.swing.JLabel();
  javax.swing.JCheckBox visibleBox = new javax.swing.JCheckBox();
  javax.swing.JCheckBox selectableBox = new javax.swing.JCheckBox();
  javax.swing.JCheckBox resizableBox = new javax.swing.JCheckBox();
  javax.swing.JCheckBox draggableBox = new javax.swing.JCheckBox();
  javax.swing.JLabel label4 = new javax.swing.JLabel();
  javax.swing.JTextField widthField = new javax.swing.JTextField();
  javax.swing.JLabel classNameLabel = new javax.swing.JLabel();
  javax.swing.JLabel fromLabel = new javax.swing.JLabel();
  javax.swing.JTextField location = new javax.swing.JTextField();
  javax.swing.ButtonGroup group1 = new javax.swing.ButtonGroup();
  javax.swing.JRadioButton fromFile = new javax.swing.JRadioButton();
  javax.swing.JRadioButton fromURL = new javax.swing.JRadioButton();
  javax.swing.JLabel label5 = new javax.swing.JLabel();
  javax.swing.JCheckBox transparent = new javax.swing.JCheckBox();
  javax.swing.JButton transButton = new javax.swing.JButton();

  public JGoImage myObject;
  private String myFile = null;
  private URL myURL = null;
  private Image myImage = null;
  private Color myColor = null;

  public ImagePropsDialog(Frame frame, String title, boolean modal, JGoImage obj)
  {
    super(frame, title, modal);
    try  {
      myObject = obj;
      jbInit();
      pack();
      UpdateDialog();
    }
    catch(Exception ex) {
      ex.printStackTrace();
    }
  }

  public ImagePropsDialog()
  {
    this(null, "", false, null);
  }

  void jbInit() throws Exception
  {
    panel1.setLayout(null);
    panel1.setMinimumSize(new Dimension(294, 331));
    panel1.setPreferredSize(new Dimension(294, 331));
    OKButton.addActionListener(new java.awt.event.ActionListener() {

      public void actionPerformed(ActionEvent e) {
        OKButton_actionPerformed(e);
      }
    });
    CancelButton.addActionListener(new java.awt.event.ActionListener() {

      public void actionPerformed(ActionEvent e) {
        CancelButton_actionPerformed(e);
      }
    });
    transButton.addActionListener(new java.awt.event.ActionListener() {

      public void actionPerformed(ActionEvent e) {
        transButton_actionPerformed(e);
      }
    });
    this.setResizable(false);
    getContentPane().add(panel1);

    OKButton.setText("OK");
    panel1.add(OKButton);
    OKButton.setFont(new Font("Dialog", Font.PLAIN, 12));
    OKButton.setBounds(new Rectangle(56,302,79,22));
    CancelButton.setText("Cancel");
    panel1.add(CancelButton);
    CancelButton.setFont(new Font("Dialog", Font.PLAIN, 12));
    CancelButton.setBounds(new Rectangle(164,302,79,22));
    label1.setText("Height:");
    label1.setHorizontalAlignment(JLabel.RIGHT);
    panel1.add(label1);
    label1.setBounds(new Rectangle(132,60,48,24));
    panel1.add(heightField);
    heightField.setBounds(new Rectangle(192,60,36,24));
    panel1.add(xField);
    xField.setBounds(new Rectangle(84,36,36,24));
    label2.setText("x:");
    label2.setHorizontalAlignment(JLabel.RIGHT);
    panel1.add(label2);
    label2.setBounds(new Rectangle(24,36,48,24));
    panel1.add(yField);
    yField.setBounds(new Rectangle(84,60,36,24));
    label3.setText("y:");
    label3.setHorizontalAlignment(JLabel.RIGHT);
    panel1.add(label3);
    label3.setBounds(new Rectangle(24,60,48,24));
    visibleBox.setText("Visible");
    panel1.add(visibleBox);
    visibleBox.setBounds(new Rectangle(24,96,96,24));
    selectableBox.setText("Selectable");
    panel1.add(selectableBox);
    selectableBox.setBounds(new Rectangle(24,120,96,24));
    resizableBox.setText("Resizable");
    panel1.add(resizableBox);
    resizableBox.setBounds(new Rectangle(24,144,96,24));
    draggableBox.setText("Draggable");
    panel1.add(draggableBox);
    draggableBox.setBounds(new Rectangle(24,168,96,24));
    label4.setText("Width:");
    label4.setHorizontalAlignment(JLabel.RIGHT);
    panel1.add(label4);
    label4.setBounds(new Rectangle(132,36,48,24));
    panel1.add(widthField);
    widthField.setBounds(new Rectangle(192,36,36,24));
    classNameLabel.setText("class name");
    panel1.add(classNameLabel);
    classNameLabel.setBounds(new Rectangle(23,5,264,24));
    fromLabel.setText("Image Location:");
    panel1.add(fromLabel);
    fromLabel.setBounds(new Rectangle(156,120,100,24));
    group1.add(fromFile);
    group1.add(fromURL);
    fromFile.setText("From File");
    panel1.add(fromFile);
    fromFile.setBounds(new Rectangle(156,144,100,24));
    fromURL.setText("From URL");
    panel1.add(fromURL);
    fromURL.setBounds(new Rectangle(156,168,100,24));
    label5.setText("URL or Pathname:");
    panel1.add(label5);
    label5.setBounds(new Rectangle(24,192,150,24));
    panel1.add(location);
    location.setBounds(new Rectangle(24,216,246,24));
    transparent.setText("Transparent Background Filled?");
    panel1.add(transparent);
    transparent.setBounds(new Rectangle(50, 246, 200, 24));
    transButton.setText("Transparent Fill Color...");
    panel1.add(transButton);
    transButton.setBounds(new Rectangle(64, 270, 166, 24));
  }

  void UpdateDialog()
  {
    if (myObject == null) return;
    myFile = myObject.getFilename();
    myURL = myObject.getURL();
    myImage = myObject.getImage();
    myColor = myObject.getTransparentColor();
    if (myColor != null)
      transparent.setSelected(true);
    classNameLabel.setText(myObject.getClass().getName());
    Rectangle rect = myObject.getBoundingRect();
    xField.setText(String.valueOf(rect.x));
    yField.setText(String.valueOf(rect.y));
    heightField.setText(String.valueOf(rect.height));
    widthField.setText(String.valueOf(rect.width));
    visibleBox.setSelected(myObject.isVisible());
    selectableBox.setSelected(myObject.isSelectable());
    resizableBox.setSelected(myObject.isResizable());
    draggableBox.setSelected(myObject.isDraggable());
    if (myFile != null) {
      location.setText(myFile);
      fromFile.setSelected(true);
    }
    else if (myURL != null) {
      location.setText(myURL.toString());
      fromURL.setSelected(true);
    }
  }

  void UpdateControl()
  {
    if (myObject == null) return;

    Rectangle rect = new Rectangle(Integer.parseInt(xField.getText()),
                                   Integer.parseInt(yField.getText()),
                                   Integer.parseInt(widthField.getText()),
                                   Integer.parseInt(heightField.getText()));
    myObject.setBoundingRect(rect);
    myObject.setVisible(visibleBox.isSelected());
    myObject.setSelectable(selectableBox.isSelected());
    myObject.setResizable(resizableBox.isSelected());
    myObject.setDraggable(draggableBox.isSelected());
    if (fromFile.isSelected()) {
      if (!myObject.loadImage(location.getText(), true))
        setPrevious();
    }
    else //fromURL must be selected.
      try{
        if (!myObject.loadImage(new URL(location.getText()), true))
          setPrevious();
      } catch (java.net.MalformedURLException e) { setPrevious();}
    if (!transparent.isSelected())
      myColor = null;
    myObject.setTransparentColor(myColor);
  }

  public void addNotify()
  {
    // Record the size of the window prior to calling parents addNotify.
    Dimension d = getSize();

    super.addNotify();

    if (fComponentsAdjusted)
      return;

    // Adjust components according to the insets
    Insets insets = getInsets();
    setSize(insets.left + insets.right + d.width, insets.top + insets.bottom + d.height);
    Component components[] = getComponents();
    for (int i = 0; i < components.length; i++)
    {
      Point p = components[i].getLocation();
      p.translate(insets.left, insets.top);
      components[i].setLocation(p);
    }
    fComponentsAdjusted = true;
  }

  // Used for addNotify check.
  boolean fComponentsAdjusted = false;

  private void setPrevious()
  {
    if (myURL != null)
      myObject.loadImage(myURL, true);
    else if (myFile != null)
      myObject.loadImage(myFile, true);
    else
      myObject.loadImage(myImage, true);
  }

  /**
   * Shows or hides the component depending on the boolean flag b.
   * @param b  if true, show the component; otherwise, hide the component.
   * @see javax.swing.JComponent#isVisible
   */
  public void setVisible(boolean b)
  {
    if (b) {
      Rectangle bounds = getParent().getBounds();
      Rectangle abounds = getBounds();

      setLocation(bounds.x + (bounds.width - abounds.width)/ 2,
                  bounds.y + (bounds.height - abounds.height)/2);
    }
    super.setVisible(b);
  }

  void OKButton_actionPerformed(ActionEvent e)
  {
    OnOK();
  }

  void OnOK()
  {
    try {
        UpdateControl();
          this.dispose();             // Free system resources
    } catch (Exception e) {
    }
  }

  void CancelButton_actionPerformed(ActionEvent e)
  {
    OnCancel();
  }

  void OnCancel()
  {
    try {
      this.dispose();             // Free system resources
    } catch (Exception e) {
    }
  }

  void transButton_actionPerformed(ActionEvent e) {
    Color newcolor = JColorChooser.showDialog(this, "Transparent Color", myColor);
    if (newcolor != null)
        myColor = newcolor;
  }

}
