/*
 *  Copyright (c) Northwoods Software Corporation, 1998-2008. All Rights
 *  Reserved.
 *
 *  Restricted Rights: Use, duplication, or disclosure by the U.S.
 *  Government is subject to restrictions as set forth in subparagraph
 *  (c) (1) (ii) of DFARS 252.227-7013, or in FAR 52.227-19, or in FAR
 *  52.227-14 Alt. III, as applicable.
 *
 */

package com.nwoods.jgo.examples.demo1;

import java.util.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.table.*;
import java.lang.reflect.*;
import com.nwoods.jgo.*;

public class Inspector
{

  public static class InspectorTableModel extends AbstractTableModel
  {
    public InspectorTableModel() {}

    public Object getObject() { return myObject; }

    public void setObject(Object obj) {
      myObject = obj;
      myGetters = new ArrayList();
      mySetters = new ArrayList();
      if (myObject != null) {
        addMethods(myObject.getClass());
      }
      fireTableChanged(new TableModelEvent(this));
    }

    public String getColumnName(int col) {
      if (col == 0) return "Property";
      else return "Value";
    }

    public int getColumnCount() { return 2; }

    public int getRowCount() {
      return myGetters.size();
    }

    public Object getValueAt(int row, int col) {
      Method m = (Method)myGetters.get(row);
      if (col == 0) {
        return getPropertyName(m);
      } else {
        try {
          Object val = m.invoke(myObject, new Object[] {});
          if (val instanceof Point) {
            Point p = (Point)val;
            return Integer.toString(p.x) + "," + Integer.toString(p.y);
          } else if (val instanceof Dimension) {
            Dimension d = (Dimension)val;
            return Integer.toString(d.width) + "x" + Integer.toString(d.height);
          } else if (val instanceof Rectangle) {
            Rectangle r = (Rectangle)val;
            return Integer.toString(r.x) + "," + Integer.toString(r.y) + ";" + Integer.toString(r.width) + "x" + Integer.toString(r.height);
          }
          return val;
        } catch (Exception x) {
          return x.toString();
        }
      }
    }

    public boolean isCellEditable(int row, int col) {
      if (col == 1 && mySetters.get(row) != null) {
        Class type = myObject.getClass();
        if (type != Color.class && type != Insets.class &&
            type != JGoPen.class && type != JGoBrush.class)
          return true;
      }
      return false;
    }

    public void setValueAt(Object value, int row, int col) {
      Method setter = (Method)mySetters.get(row);
      if (setter == null) return;
      Class[] paramtypes = setter.getParameterTypes();
      if (paramtypes.length == 0) return;
      Class type = paramtypes[0];
      if (value instanceof String) {
        String v = (String)value;
        if (type == String.class) {
          invokeSetter(setter, v);
        } else if (type == boolean.class) {
          Boolean newval = Boolean.FALSE;
          if (v.equals("true"))
            newval = Boolean.TRUE;
          invokeSetter(setter, newval);
        } else if (type == int.class) {
          try {
            Integer newval = Integer.valueOf(v);
            invokeSetter(setter, newval);
          } catch (Exception x) {
            JOptionPane.showMessageDialog(null, x.toString());
          }
        } else if (type == float.class) {
          try {
            Float newval = Float.valueOf(v);
            invokeSetter(setter, newval);
          } catch (Exception x) {
            JOptionPane.showMessageDialog(null, x.toString());
          }
        } else if (type == double.class) {
          try {
            Double newval = Double.valueOf(v);
            invokeSetter(setter, newval);
          } catch (Exception x) {
            JOptionPane.showMessageDialog(null, x.toString());
          }
        } else if (type == Point.class) {
          try {
            int comma = v.indexOf(',');
            int x = Integer.parseInt(v.substring(0, comma).trim());
            int y = Integer.parseInt(v.substring(comma+1).trim());
            Point newval = new Point(x, y);
            invokeSetter(setter, newval);
          } catch (Exception x) {
            JOptionPane.showMessageDialog(null, x.toString());
          }
        } else if (type == Dimension.class) {
          try {
            int comma = v.indexOf('x');
            int w = Integer.parseInt(v.substring(0, comma).trim());
            int h = Integer.parseInt(v.substring(comma+1).trim());
            Dimension newval = new Dimension(w, h);
            invokeSetter(setter, newval);
          } catch (Exception x) {
            JOptionPane.showMessageDialog(null, x.toString());

          }
        } else if (type == Rectangle.class) {
          try {
            int comma = v.indexOf(',');
            int x = Integer.parseInt(v.substring(0, comma).trim());
            int semicolon = v.indexOf(';');
            int y = Integer.parseInt(v.substring(comma+1, semicolon).trim());
            int by = v.indexOf('x');
            int w = Integer.parseInt(v.substring(semicolon+1, by).trim());
            int h = Integer.parseInt(v.substring(by+1).trim());
            Point newval = new Point(x, y);
            invokeSetter(setter, newval);
          } catch (Exception x) {
            JOptionPane.showMessageDialog(null, x.toString());
          }
        } else {
          JOptionPane.showMessageDialog(null, "not handled: type=" + type.toString() + " value=" + v);
        }
      } else {
        JOptionPane.showMessageDialog(null, "not handled: type=" + type.toString() +
                                            ", valuetype=" + value.getClass().toString() +
                                            " value=" + value.toString());
      }
      fireTableChanged(new TableModelEvent(this));
    }

    private void invokeSetter(Method setter, Object newval) {
      JGoDocument doc = null;
      if (myObject instanceof JGoDocument)
        doc = (JGoDocument)myObject;
      else if (myObject instanceof JGoObject)
        doc = ((JGoObject)myObject).getDocument();
      else if (myObject instanceof JGoLayer)
        doc = ((JGoLayer)myObject).getDocument();
      else if (myObject instanceof JGoView)
        doc = ((JGoView)myObject).getDocument();
      else if (myObject instanceof JGoSelection)
        doc = ((JGoSelection)myObject).getView().getDocument();
      if (doc != null)
        doc.startTransaction();
      try {
        setter.invoke(myObject, new Object[] { newval });
      } catch (Exception x) {
        JOptionPane.showMessageDialog(null, x.toString());
      }
      if (doc != null)
        doc.endTransaction("modified property: " + setter.toString());
    }


    public void mouseClicked(int count, int row, int column) {
      if (count >= 2) {
        Method getter = (Method)myGetters.get(row);
        Class type = getter.getReturnType();
        if (type != String.class && type != boolean.class && type != int.class &&
            type != float.class && type != double.class && type != Class.class &&
            type != Point.class && type != Dimension.class && type != Rectangle.class &&
            type != Color.class && type != Insets.class) {
          Object value = getValueAt(row, 1);
          if (value != null)
            setObject(value);
        }
      }
    }

    public boolean isEditableObject(Object obj) {
      if ((obj instanceof String) ||
        (obj instanceof Boolean) ||
        (obj instanceof Integer) ||
        (obj instanceof Float) ||
        (obj instanceof Double) ||
        (obj instanceof Point) ||
        (obj instanceof Dimension) ||
        (obj instanceof Rectangle) ||
        (obj instanceof Color) ||
        (obj instanceof Insets)) {
      return true;
    }
    return false;
    }

    private void addMethods(Class c) {
      if (c.getSuperclass() != null)
        addMethods(c.getSuperclass());
      Method[] methods = c.getDeclaredMethods();
      for (int i = 0; i < methods.length; i++) {
        Method m = methods[i];
        if (isDisplayable(m)) {
          myGetters.add(m);
          String setname = "set" + getPropertyName(m);
          try {
            Method setter = myObject.getClass().getMethod(setname, new Class[] { m.getReturnType() });
            mySetters.add(setter);
          } catch (Exception x) {
            mySetters.add(null);
          }
        }
      }
    }

    private String getPropertyName(Method m) {
      String name = m.getName();
      if (name.length() > 3 && name.substring(0, 3).equals("get"))
        return name.substring(3);
      else if (name.length() > 2 && name.substring(0, 2).equals("is"))
        return name.substring(2);
      else return null;
    }

    private boolean isDisplayable(Method m) {
      return m.getParameterTypes().length == 0 &&
             getPropertyName(m) != null &&
             Modifier.isPublic(m.getModifiers());
    }

    private Object myObject = null;
    private ArrayList myGetters = new ArrayList();
    private ArrayList mySetters = new ArrayList();
  }

  public static void inspect(Object obj) {
    try {
      if (myDialog == null) {
        myModel = new InspectorTableModel();
        myTable = new JTable(myModel);
        myTable.setPreferredScrollableViewportSize(new Dimension(300, 500));
        myTable.addMouseListener(new MouseAdapter() {
            public void mouseClicked(MouseEvent evt) {
              myModel.mouseClicked(evt.getClickCount(), myTable.rowAtPoint(evt.getPoint()), myTable.columnAtPoint(evt.getPoint()));
            }
          });
        JScrollPane myPane = new JScrollPane(myTable);
        JDialog dlg = new JDialog((Frame)Demo1.getApp(), "Properties", false);
        dlg.getContentPane().setLayout(new BorderLayout());
        dlg.getContentPane().add(myPane, BorderLayout.CENTER);
        dlg.pack();
        dlg.setVisible(true);
        myDialog = dlg;
      }
      myModel.setObject(obj);
      myTable.getColumnModel().getColumn(0).setPreferredWidth(35);
      if (!myDialog.isVisible()) myDialog.setVisible(true);
    } catch (Exception e) {
      System.err.println(e);
      e.printStackTrace();
    }
  }

    public static void refresh() {
      if (myModel != null && myDialog != null && myDialog.isVisible()) {
        myModel.setObject(myModel.getObject());
      }
  }

  private static InspectorTableModel myModel = null;
  public static JDialog getInspector() { return myDialog; }

  private static JDialog myDialog = null;
  private static JTable myTable = null;
}
