/*
 *  Copyright (c) Northwoods Software Corporation, 1998-2008. All Rights
 *  Reserved.
 *
 *  Restricted Rights: Use, duplication, or disclosure by the U.S.
 *  Government is subject to restrictions as set forth in subparagraph
 *  (c) (1) (ii) of DFARS 252.227-7013, or in FAR 52.227-19, or in FAR
 *  52.227-14 Alt. III, as applicable.
 *
 */

package com.nwoods.jgo.examples.demo1;

import java.awt.*;
import java.awt.event.*;
import com.nwoods.jgo.*;

public class LimitedNode extends JGoBasicNode {
  public LimitedNode() {}
  public LimitedNode(String s) { super(s); }

  // limit the X axis Location of this node to between 50 and 500
  public Point computeMove(int origX, int origY, int newX, int newY, Point result) {
    if (result == null)
      result = new Point(0, 0);
    if (newX < 50)
      result.x = 50;
    else if (newX > 500)
      result.x = 500;
    else
      result.x = newX;
    result.y = newY;
    return result;
  }
}
