/*
 *  Copyright (c) Northwoods Software Corporation, 1998-2008. All Rights
 *  Reserved.
 *
 *  Restricted Rights: Use, duplication, or disclosure by the U.S.
 *  Government is subject to restrictions as set forth in subparagraph
 *  (c) (1) (ii) of DFARS 252.227-7013, or in FAR 52.227-19, or in FAR
 *  52.227-14 Alt. III, as applicable.
 *
 */

package com.nwoods.jgo.examples.demo1;

import java.awt.*;
import com.nwoods.jgo.*;

public class LinearGradientEllipse extends JGoEllipse {
  public LinearGradientEllipse() { super(); }

  // make sure there's a color gradient going from the top-middle to the
  // bottom middle of the ellipse, no matter where the ellipse is or how big it is.
  public void geometryChange(Rectangle prevRect) {
    super.geometryChange(prevRect);
    setBrush(null);
  }

  public JGoBrush getBrush() {
    JGoBrush b = super.getBrush();
    if (b == null) {
      Rectangle rect = getBoundingRect();
      b = new JGoBrush(new GradientPaint(rect.x + rect.width/2, rect.y, getStartColor(),
                                         rect.x + rect.width/2, rect.y + rect.height, getEndColor()));
      setBrush(b);
    }
    return b;
  }

  public Color getStartColor() { return myStartColor; }
  public void setStartColor(Color value) {
    Color old = myStartColor;
    if (old != value) {
      myStartColor = value;
      setBrush(null);
      update(ChangedStartColor, 0, old);
    }
  }

  public Color getEndColor() { return myEndColor; }
  public void setEndColor(Color value) {
    Color old = myEndColor;
    if (old != value) {
      myEndColor = value;
      setBrush(null);
      update(ChangedEndColor, 0, old);
    }
  }

  public void copyNewValueForRedo(JGoDocumentChangedEdit e) {
    switch (e.getFlags()) {
      case ChangedStartColor:
        e.setNewValue(getStartColor());
        return;
      case ChangedEndColor:
        e.setNewValue(getEndColor());
        return;
      default:
        super.copyNewValueForRedo(e);
        return;
    }
  }

  public void changeValue(JGoDocumentChangedEdit e, boolean undo) {
    switch (e.getFlags()) {
      case ChangedGeometry:
        super.changeValue(e, undo);
        setBrush(null);
        break;
      case ChangedStartColor:
        setStartColor((Color)e.getValue(undo));
        break;
      case ChangedEndColor:
        setEndColor((Color)e.getValue(undo));
        break;
      default:
        super.changeValue(e, undo);
        break;
    }
  }

  public static final int ChangedStartColor = LastChangedHint + 512;
  public static final int ChangedEndColor = LastChangedHint + 513;

  private Color myStartColor = Color.white;
  private Color myEndColor = Color.gray;
}
