/*
 *  Copyright (c) Northwoods Software Corporation, 1998-2008. All Rights
 *  Reserved.
 *
 *  Restricted Rights: Use, duplication, or disclosure by the U.S.
 *  Government is subject to restrictions as set forth in subparagraph
 *  (c) (1) (ii) of DFARS 252.227-7013, or in FAR 52.227-19, or in FAR
 *  52.227-14 Alt. III, as applicable.
 *
 */

package com.nwoods.jgo.examples.demo1;

import java.awt.*;
import com.nwoods.jgo.*;

public class TestSubGraph extends JGoSubGraph {
  public TestSubGraph() {}  // default constructor, just for copying

  public TestSubGraph(String s) { super(s); init(); }

  /**
   * Create an input port and an output port, each a green triangle.
   */
  public void init() {
    setInitializing(true);
    setLabelSpot(JGoObject.TopLeft);
    setCollapsedLabelSpot(JGoObject.BottomCenter);
    setInsets(new Insets(10, 10, 10, 10));
    setCollapsedInsets(new Insets(10, 10, 10, 10));

    myInput = new JGoPort();
    myInput.setSize(7, 7);
    myInput.setBrush(JGoBrush.green);
    myInput.setStyle(JGoPort.StyleTriangle);
    myInput.setValidSource(false);
    addObjectAtTail(myInput);

    myOutput = new JGoPort();
    myOutput.setSize(7, 7);
    myOutput.setBrush(JGoBrush.green);
    myOutput.setStyle(JGoPort.StyleTriangle);
    myOutput.setValidDestination(false);
    addObjectAtTail(myOutput);

    setInitializing(false);
    layoutChildren(null);
  }

  protected void copyChildren(JGoArea newarea, JGoCopyEnvironment env) {
    super.copyChildren(newarea, env);
    TestSubGraph newobj = (TestSubGraph)newarea;
    newobj.myInput = (JGoPort)env.get(myInput);
    newobj.myOutput = (JGoPort)env.get(myOutput);
  }
  
  public JGoObject removeObjectAtPos(JGoListPosition pos) {
    JGoObject child = super.removeObjectAtPos(pos);
    if (child == myInput)
      myInput = null;
    else if (child == myOutput)
      myOutput = null;
    return child;
  }

  /**
   * The input port is positioned inside the center left point of the subgraph;
   * the output port is position inside the center right spot.
   */
  public void layoutPort() {
    Rectangle b = computeBorder();
    if (getInput() != null) {
      getInput().setSpotLocation(CenterLeft, new Point(b.x, b.y+b.height/2));
    }
    if (getOutput() != null) {
      getOutput().setSpotLocation(CenterRight, new Point(b.x+b.width, b.y+b.height/2));
    }
  }

  public JGoPort getInput() { return myInput; }
  public JGoPort getOutput() { return myOutput; }

  private JGoPort myInput = null;
  private JGoPort myOutput = null;
}
