/*
 *  Copyright (c) Northwoods Software Corporation, 1998-2008. All Rights
 *  Reserved.
 *
 *  Restricted Rights: Use, duplication, or disclosure by the U.S.
 *  Government is subject to restrictions as set forth in subparagraph
 *  (c) (1) (ii) of DFARS 252.227-7013, or in FAR 52.227-19, or in FAR
 *  52.227-14 Alt. III, as applicable.
 *
 */

package com.nwoods.jgo.examples.demo1;

import java.awt.*;
import com.nwoods.jgo.*;

public class TestSubGraph2 extends JGoSubGraph {
  public TestSubGraph2() { init(); }  // default constructor, just for copying

  public TestSubGraph2(String s) { super(s); init(); }

  public void init() {
    setCollapsedLabelSpot(JGoObject.BottomCenter);
    setInsets(new Insets(10, 10, 10, 10));
    setCollapsedInsets(new Insets(10, 10, 10, 10));
    setBorderPen(JGoPen.black);
  }

  // Position the Handle at the top-left corner of the border,
  // not just inside the margins.
  protected void layoutHandle() {
    if (!isExpanded()) return;
    JGoSubGraphHandle h = getHandle();
    if (h != null) {
      Rectangle r = computeBorder();
      h.setTopLeft(r.x, r.y);
    }
  }
  
  /**
   * This subgraph has a "hollow" port representing the whole subgraph.
   * <p>
   * Users will be able to starting dragging a new link along the
   * margins of the subgraph.
   */
  protected JGoPort createPort() {
    return new TestSubGraph2Port();
  }

  /**
   * When the subgraph is collapsed and there is a collapsed object,
   * the port has the same bounds as the collapsed object;
   * otherwise, the port has the same bounds as the whole subgraph.
   */
  public void layoutPort() {
    JGoPort p = getPort();
    if (p != null && p.isVisible()) {
      if (!isExpanded() && getCollapsedObject() != null && getCollapsedObject().isVisible()) {
        p.setBoundingRect(getCollapsedObject().getBoundingRect());
      } else {
        Rectangle b = computeBorder();
        p.setBoundingRect(b);
      }
    }
  }
}
