/*
 *  Copyright (c) Northwoods Software Corporation, 1998-2008. All Rights
 *  Reserved.
 *
 *  Restricted Rights: Use, duplication, or disclosure by the U.S.
 *  Government is subject to restrictions as set forth in subparagraph
 *  (c) (1) (ii) of DFARS 252.227-7013, or in FAR 52.227-19, or in FAR
 *  52.227-14 Alt. III, as applicable.
 *
 */

package com.nwoods.jgo.examples.demo1;

import java.awt.*;
import com.nwoods.jgo.*;

public class TestSubGraph2Port extends JGoPort {
  public TestSubGraph2Port() {
    setFromSpot(NoSpot);
    setToSpot(NoSpot);
    setStyle(JGoPort.StyleHidden);
  }

  /**
   * Make this port "hollow" by not allowing a pick inside the
   * bounds of the port except along an outer margin.
   */
  public JGoObject pick(Point p, boolean selectableOnly) {
    Rectangle r = getBoundingRect();
    int margin = 5;
    if (p.x > r.x+margin && p.x < r.x+r.width-margin &&
        p.y > r.y+margin && p.y < r.y+r.height-margin)
      return null;
    else
      return super.pick(p, selectableOnly);
  }
}
