/*
 *  Copyright (c) Northwoods Software Corporation, 2000-2008. All Rights Reserved.
 *
 *  Restricted Rights: Use, duplication, or disclosure by the U.S.
 *  Government is subject to restrictions as set forth in subparagraph
 *  (c) (1) (ii) of DFARS 252.227-7013, or in FAR 52.227-19, or in FAR
 *  52.227-14 Alt. III, as applicable.
 */


// To use the JGoLayout automatic layout library,
// uncomment the contents of this file, the contents of FamilyNetwork.java,
// as well as the lines of code found in FamilyTreeDoc.java (follow instructions
// in the other files to find out what changes to make.
//
// *****Note*****
// You must have purchased the JGoAutoLayout package, or have the
// evaluation version in order to use the layered digraph auto layout code.

/*
package com.nwoods.jgo.examples.family;

import java.util.NoSuchElementException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.awt.Dimension;
import java.awt.Point;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoLink;
import com.nwoods.jgo.JGoPort;
import com.nwoods.jgo.JGoLabeledLink;
import com.nwoods.jgo.layout.*;
import java.io.*;

//
// FamilyLDAL provides an auto-layout for family trees created in the FamilyTree
// JGo Demo application.  FamilyLDAL provides an auto-layout
// algorithm for directed graphs.  The method uses a hierarchical approach
// for creating drawings of digraphs with nodes arranged in layers.
// The layout algorithm consists of four-major steps: Cycle Removal,
// Layer Assignment, Crossing Reduction, and Straightening and Packing.
//

public class FamilyLDAL extends JGoLayeredDigraphAutoLayout
{
  public FamilyLDAL(JGoDocument doc, JGoNetwork network)
	{
	  super(doc, network, 10, 10, JGoLayeredDigraphAutoLayout.LD_DIRECTION_DOWN,
         JGoLayeredDigraphAutoLayout.LD_CYCLEREMOVE_DFS, JGoLayeredDigraphAutoLayout.LD_LAYERING_OPTIMALLINKLENGTH,
         JGoLayeredDigraphAutoLayout.LD_INITIALIZE_DFSOUT, 4, JGoLayeredDigraphAutoLayout.LD_AGGRESSIVE_FALSE);
	}
	
	
	protected void makeProper()
	{
	  super.makeProper();
	  Iterator pos = getNetwork().getLinkIterator();
	  while(pos.hasNext()) {
	    JGoNetworkLink link = (JGoNetworkLink)pos.next();
	    linkData(link).portFromColOffset = 0;
	    linkData(link).portToColOffset = 0;
	  }
  }
  
  public int getLinkMinLength(JGoNetworkLink pLink)
  {
    JGoNetworkNode pFromNode = pLink.getFromNode();
    JGoNetworkNode pToNode = pLink.getToNode();
    
    if ((pFromNode.getJGoObject() != null) && (pToNode.getJGoObject() != null)) {      
      if (pLink.getJGoObject() instanceof JGoLabeledLink) {
        return 1 * super.getLinkMinLength(pLink);
      } else {
        return 4 * super.getLinkMinLength(pLink);
      }
    }
    
    return super.getLinkMinLength(pLink);
  }  
}
*/
