/*
 *  Copyright (c) Northwoods Software Corporation, 2000-2008. All Rights
 *  Reserved.
 *
 *  Restricted Rights: Use, duplication, or disclosure by the U.S.
 *  Government is subject to restrictions as set forth in subparagraph
 *  (c) (1) (ii) of DFARS 252.227-7013, or in FAR 52.227-19, or in FAR
 *  52.227-14 Alt. III, as applicable.
 *
 */

// To use the JGoLayout automatic layout library,
// uncomment the contents of this file, the contents of FamilyLDAL.java,
// as well as the lines of code found in FamilyTreeDoc.java (follow instructions
// in the other files to find out what changes to make.
//
// *****Note*****
// You must have purchased the JGoAutoLayout package, or have the
// evaluation version in order to use the layered digraph auto layout code.

/*
package com.nwoods.jgo.examples.family;

import com.nwoods.jgo.layout.*;
import java.util.Vector;
import java.util.HashMap;
import java.util.Iterator;
import com.nwoods.jgo.*;
import com.nwoods.jgo.examples.Comment;
import java.util.LinkedList;

class FamilyNetwork extends JGoNetwork
{
  public FamilyNetwork(FamilyTreeDoc collection)
  {
    super();
    JGoListPosition pos;
    JGoObject pGoObject;
    JGoNetworkLink pNetworkLink = new JGoNetworkLink();
    
    // First, add all top-level JGoObjects which are not links
    //  as nodes to the network.
    for (pos = collection.getFirstObjectPos(); pos != null; ) {
      pGoObject = collection.getObjectAtPos(pos);
      pos = collection.getNextObjectPosAtTop(pos);
      JGoObject p = pGoObject.getPartner();
      if (p != null && p.isTopLevel())
        continue;
      if (!(pGoObject instanceof JGoLink || pGoObject instanceof Comment || pGoObject instanceof JGoPort)) {
        JGoNetworkNode pNetworkNode = new JGoNetworkNode(this, pGoObject);
        addNode(pNetworkNode);
        // Record the mapping of this top-level JGoObject to its
        //  corresponding node.
        getGoObjToNodeMap().put(pGoObject, pNetworkNode);
      }
    }
    
    // Second, add all top-level JGoLinks as links to the network.
    // Note: a link cannot be added to the network unless both of
    //  its to and from nodes are in the network.  Hence, it is possible
    //  to select a JGoLink without selecting the JGoObjects at its
    //  endpoints, but the JGoLink will not be added to the network.
    for (pos = collection.getFirstObjectPos(); pos != null; ) {
      pGoObject = collection.getObjectAtPos(pos);
      pos = collection.getNextObjectPosAtTop(pos);
      if (pGoObject instanceof JGoLabeledLink) {
        JGoPort pFromPort = ((JGoLink)pGoObject).getFromPort();
        JGoPort pToPort = ((JGoLink)pGoObject).getToPort();
        
        // Climb to the top-level JGoObject for the from node.
        JGoObject pFromObject = pFromPort;
        while (pFromObject.getParent() != null) {
          pFromObject = pFromObject.getParent();
        }
        
        // Climb to the top-level JGoObject for the to node.
        JGoObject pToObject = pToPort;
        while (pToObject.getParent() != null) {
          pToObject = pToObject.getParent();
        }
        
        // Verify that the top-level JGoObject for the from and to nodes
        //  are in the network and add a link between them.
        JGoNetworkNode pFromNode, pToNode;
        
        if ((getGoObjToNodeMap().containsKey(pFromObject) && getGoObjToNodeMap().containsKey(pToObject))) {
          pFromNode = (JGoNetworkNode)getGoObjToNodeMap().get(pFromObject);
          pToNode = (JGoNetworkNode)getGoObjToNodeMap().get(pToObject);
          if (((PersonNode)pFromObject).getPerson().isMale()){
            pNetworkLink = linkNodes(pFromNode, pToNode, pGoObject);
            JGoLabeledLink ll = (JGoLabeledLink)pGoObject;
            JGoPort mp = (JGoPort)(ll.getMidLabel());
            if (mp != null) {
              ll.setToLabel(mp);
              ll.setMidLabel(null);
            }
          }
          else {
            pNetworkLink = linkNodes(pToNode, pFromNode, pGoObject);
            JGoLabeledLink ll = (JGoLabeledLink)pGoObject;
            JGoPort mp = (JGoPort)(ll.getMidLabel());
            if (mp != null) {
              ll.setFromLabel(mp);
              ll.setMidLabel(null);
            }
          }
        }
        
        // Record the mapping of this top-level JGoObject to its
        //  corresponding node.
        getGoObjToLinkMap().put(pGoObject, pNetworkLink);
      }
      else if (pGoObject instanceof JGoLink) {
        //child link.  add links from both parents.
        JGoPort cp = ((JGoLink)pGoObject).getToPort();
        Person child = ((PersonNode)(cp.getParent())).getPerson();
        PersonNode mother = collection.findNode(collection.getDB().findPerson(child.mother));
        PersonNode ch = collection.findNode(child);
        JGoNetworkNode m = (JGoNetworkNode)getGoObjToNodeMap().get(mother);
        JGoNetworkNode c = (JGoNetworkNode)getGoObjToNodeMap().get(ch);
        JGoNetworkLink l = linkNodes(m, c, pGoObject);
      }
    }
  }
}
*/
