/*
 *  Copyright (c) Northwoods Software Corporation, 2000-2008. All Rights
 *  Reserved.
 *
 *  Restricted Rights: Use, duplication, or disclosure by the U.S.
 *  Government is subject to restrictions as set forth in subparagraph
 *  (c) (1) (ii) of DFARS 252.227-7013, or in FAR 52.227-19, or in FAR
 *  52.227-14 Alt. III, as applicable.
 *
 */

package com.nwoods.jgo.examples.family;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import com.nwoods.jgo.*;


/**
 * This simple app show a part of the family tree of a famous family.
 * People are represented by color-coded nodes.  Marriages are represented
 * by thick green links between two nodes.  Child-parent relationships are
 * represented by links from the child to the particular marriage linking
 * the biological mother and biological father.  Tooltips present additional
 * information, if available, for each person.
 * <p>
 * Because this is an example, commands are limited to direct manipulation
 * and keyboard commands, the genealogical database is kept very simple, and
 * the automatic layout of the nodes in the document is moderately simple.
 */
public class FamilyTree extends JApplet implements Runnable
{
  public FamilyTree()
  {
    // Create the JGo model for the family tree view
    myDoc = new FamilyTreeDoc();
    // Create the main graphics window
    myView = new JGoView(myDoc);

    // Process KeyEvents from the JGoView--handle the Delete key.
    //
    // Normally one overrides JGoView.onKeyEvent() to make use of the
    // default behavior supplied by JGoView.  Using a listener,
    // as this example does, may lead to duplicate and/or conflicting
    // actions if the same key is handled, and does not allow
    // inhibiting the default behavior.  For this example program,
    // we assume the default behavior is OK, and we don't want to
    // bother creating a subclass of JGoView yet.
    myView.addKeyListener(new KeyAdapter() {
      public void keyPressed(KeyEvent evt) {
        int t = evt.getKeyCode();
        if (t == KeyEvent.VK_DELETE) {
          // delete all selected PersonNodes
          myView.deleteSelection();
        } else if (t == KeyEvent.VK_INSERT) {
          // delete everything and then start over
          myDoc.deleteContents();
          myDoc.initNodes();
        } else if (evt.isControlDown() && t == KeyEvent.VK_L) {
          // re-layout all the nodes
          myView.getSelection().clearSelectionHandles(null);
          myDoc.layoutNodes();
          myView.getSelection().restoreSelectionHandles(null);
        } else if (evt.isControlDown() && t == KeyEvent.VK_Q) {
          System.exit(0);
        } else if (evt.isControlDown() && t == KeyEvent.VK_P) {
          myView.print();
        }
      }
    });

    // the view is the main window
    Container contentPane = getContentPane();
    contentPane.setLayout(new BorderLayout());
    contentPane.add(myView, BorderLayout.CENTER);
    contentPane.validate();
  }

  public void init()
  {
    // create the initial set of PersonNodes from the database
    myDoc.initNodes();
  }

  public void start()
  {
    // enable drag-and-drop from separate thread
    new Thread(this).start();
  }

  public void run() {
    myView.initializeDragDropHandling();
  }

  static public void main(String args[])
  {
    try {
      UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());

      final JFrame mainFrame = new JFrame();

      // close the application when the main window closes
      mainFrame.addWindowListener(new WindowAdapter() {
        public void windowClosing(java.awt.event.WindowEvent event) {
          Object object = event.getSource();
          if (object == mainFrame)
            System.exit(0);
        }
      });

      mainFrame.setTitle("The Tudors");
      Dimension screensize = Toolkit.getDefaultToolkit().getScreenSize();
      mainFrame.setBounds(0, 0, screensize.width, screensize.height);

      FamilyTree app = new FamilyTree();
      Container contentPane = mainFrame.getContentPane();
      contentPane.setLayout(new BorderLayout());
      contentPane.add(app, BorderLayout.CENTER);
      contentPane.validate();

      mainFrame.setVisible(true);

      app.init();
      app.start();
    } catch (Throwable t) {
      System.err.println(t);
      t.printStackTrace();
      System.exit(1);
    }
  }

  // State
  protected JGoView myView;
  protected FamilyTreeDoc myDoc;
}
