/*
 *  Copyright (c) Northwoods Software Corporation, 2000-2008. All Rights
 *  Reserved.
 *
 *  Restricted Rights: Use, duplication, or disclosure by the U.S.
 *  Government is subject to restrictions as set forth in subparagraph
 *  (c) (1) (ii) of DFARS 252.227-7013, or in FAR 52.227-19, or in FAR
 *  52.227-14 Alt. III, as applicable.
 *
 */

package com.nwoods.jgo.examples.family;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Vector;


/**
 * This represents the in-memory structure for information about
 * a particular person.  Because this is just an example program,
 * we have not put much effort into completing the database work,
 * including error checking or other work that is independent of
 * demonstrating JGo.
 * <p>
 * Both the GenDB and Person classes are completely independent of
 * any GUI (including JGo).
 *
 * @see GenDB
 */
public class Person implements Serializable
{
  public int number = UNKNOWN;
  public String name = null;
  public int sex = UNSEXED;
  public int father = UNKNOWN;
  public int mother = UNKNOWN;
  public String alias = null;
  public Calendar birthdate = null;
  public String birthplace = null;
  public Calendar baptizeddate = null;
  public String baptizedplace = null;
  public Calendar deathdate = null;
  public String deathplace = null;
  public Calendar burieddate = null;
  public String buriedplace = null;
  public Vector spouseslist = new Vector();
  public Vector weddingdateslist = new Vector();
  public Vector weddingplaceslist = new Vector();
  public Vector childrenlist = new Vector();
  public String occupation = null;
  public String notes = null;
  public int flags = 0;


  public boolean isMale() { return sex == MALE; }
  public boolean isFemale() { return sex == FEMALE; }


  public boolean isMarked(int f) { return ((flags & f) == f); }
  public void Mark(int f)     { flags = (flags | f); }
  public void Clear(int f)    { flags = (flags & ~f); }
  public void Invert(int f)   { if (isMarked(f)) Clear(f); else Mark(f); }


  public static final int UNKNOWN = -1;
  public static final int UNSEXED = 0;
  public static final int FEMALE = 1;
  public static final int MALE = 2;
}
