/*
 *  Copyright (c) Northwoods Software Corporation, 2000-2008. All Rights
 *  Reserved.
 *
 *  Restricted Rights: Use, duplication, or disclosure by the U.S.
 *  Government is subject to restrictions as set forth in subparagraph
 *  (c) (1) (ii) of DFARS 252.227-7013, or in FAR 52.227-19, or in FAR
 *  52.227-14 Alt. III, as applicable.
 *
 */
package com.nwoods.jgo.examples.flower;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

import javax.swing.text.*;


public class ActivityDialog extends JDialog {
  public ActivityNode myObject;
  JPanel panel1 = new JPanel();
  JLabel jLabel1 = new JLabel();
  JTextField taskNameField = new JTextField();
  JLabel jLabel2 = new JLabel();
  JTextField taskDurationField = new JTextField();
  JButton OKButton = new JButton();
  JButton CancelButton = new JButton();
  GridBagLayout gridBagLayout1 = new GridBagLayout();

  public ActivityDialog(Frame frame, String title, boolean modal) {
    super(frame, title, modal);
    try  {
      jbInit();
      pack();
    }
    catch(Exception ex) {
      ex.printStackTrace();
    }
  }

  public ActivityDialog() {
    this(null, "", false);
  }

  public ActivityDialog(Frame frame, ActivityNode obj)
  {
    super(frame, "Activity Properties", true);
    try  {
      myObject = obj;
      jbInit();
      pack();
      updateDialog();
    } catch(Exception ex) {
      ex.printStackTrace();
    }
  }

  void jbInit() throws Exception {
    panel1.setLayout(gridBagLayout1);
    jLabel1.setText("Task Name:");
    taskNameField.grabFocus();
    jLabel2.setText("Task Duration:");
    // taskDurationField is numeric, add KeyListener to enforce this
    taskDurationField.addKeyListener(new KeyAdapter() {
      public void keyTyped(KeyEvent e) {
        char c = e.getKeyChar();
        if (!(Character.isDigit(c) ||
           (c == KeyEvent.VK_BACK_SPACE) ||
           (c == KeyEvent.VK_DELETE))) {
          getToolkit().beep();
          e.consume();
        }
      }
    });
    OKButton.setText("OK");
    OKButton.addActionListener(new java.awt.event.ActionListener() {

      public void actionPerformed(ActionEvent e) {
        OKButton_actionPerformed(e);
      }
    });
    CancelButton.setText("Cancel");
    CancelButton.addActionListener(new java.awt.event.ActionListener() {

      public void actionPerformed(ActionEvent e) {
        CancelButton_actionPerformed(e);
      }
    });
    getContentPane().add(panel1);
    panel1.add(jLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(30, 32, 0, 13), 0, 0));
    panel1.add(jLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(31, 32, 0, 0), 0, 0));
    panel1.add(taskNameField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(30, 8, 0, 22), 118, 0));
    panel1.add(taskDurationField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(29, 8, 0, 111), 29, 0));
    panel1.add(OKButton, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(18, 50, 32, 11), 0, 0));
    panel1.add(CancelButton, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(18, 7, 32, 72), 0, 0));
    OKButton.getRootPane().setDefaultButton(OKButton);
    taskNameField.grabFocus();
  }
  
  void updateDialog()
  {
    if (myObject == null) return;

    taskNameField.setText(myObject.getLabel().getText());
    taskDurationField.setText(Integer.toString(myObject.getTaskDuration()));
  }

  void updateData()
  {
    if (myObject == null) return;

    myObject.getLabel().setText(taskNameField.getText());
    myObject.setTaskDuration(Integer.parseInt(taskDurationField.getText()));
  }

  void OKButton_actionPerformed(ActionEvent e) {
      try {
        updateData();
        this.dispose();             // Free system resources
      } catch (Exception ex) {
    }
  }

  void CancelButton_actionPerformed(ActionEvent e) {
      try {
        this.dispose();             // Free system resources
      } catch (Exception ex) {
    }
  }
}
              
