/*
 *  Copyright (c) Northwoods Software Corporation, 2000-2008. All Rights
 *  Reserved.
 *
 *  Restricted Rights: Use, duplication, or disclosure by the U.S.
 *  Government is subject to restrictions as set forth in subparagraph
 *  (c) (1) (ii) of DFARS 252.227-7013, or in FAR 52.227-19, or in FAR
 *  52.227-14 Alt. III, as applicable.
 *
 */

package com.nwoods.jgo.examples.flower;

import com.nwoods.jgo.*;
import java.awt.*;

// Flows are implemented as labeled links
//
// For this example app, the only property, Text, is
// actually just the label's Text.
public class FlowLink extends JGoLabeledLink
{
  public FlowLink()
  {
    super();
  }

  public FlowLink(JGoPort from, JGoPort to)
  {
    super(from, to);

    JGoLinkLabel text = new JGoLinkLabel("");
    text.setAlignment(JGoText.ALIGN_CENTER);
    text.setSelectable(true);
    text.setEditOnSingleClick(true);
    text.setTransparent(false);
    text.setBkColor(new Color(255, 255, 255, 200));  // partly transparent white
    setMidLabel(text);
  }

  public void initialize(String t)
  {
    setText(t);
    setAvoidsNodes(true);
    setAdjustingStyle(JGoLink.AdjustingStyleStretch);
  }

  public ProcessDocument getDoc() { return (ProcessDocument)getDocument(); }

  public ActivityNode getFromNode()
  {
    if (getFromPort() != null)
      return (ActivityNode)(getFromPort().getParent());
    return null;
  }
  public ActivityNode getToNode()
  {
    if (getToPort() != null)
      return (ActivityNode)(getToPort().getParent());
    return null;
  }


  // Events

  public boolean doMouseDblClick(int modifiers, Point dc, Point vc, JGoView view)
  {
    ProcessView processView = (ProcessView)view;
    processView.editFlow(this);
    return true;
  }

  public void unlink()
  {
     ActivityNode toNode = (ActivityNode)getToNode();
     super.unlink();
     if (toNode != null)
       toNode.updateDownstreamLinks();
  }

  // Properties

  public String getText()
  {
    JGoText obj = (JGoText)getMidLabel();
    if (obj != null)
      return obj.getText();
    else
      return "";
  }

  public void setText(String s)
  {
    JGoText obj = (JGoText)getMidLabel();
    if (obj != null)
      obj.setText(s);
  }

  // Normally you wouldn't need this--but this override of setOrthogonal
  // is here just because the user interface allows the link style
  // to be switched dynamically from Orthogonal to non-Orthogonal.
  // The overridden calculateStroke doesn't call removeAllPoints,
  // it just shifts the existing stroke points.  When the links
  // are orthogonal, extra stroke points are added, which causes
  // amusing behavior when the user switches back to non-orthogonal
  // style.
  public void setOrthogonal(boolean bOrtho)
  {
    if (bOrtho != isOrthogonal())
      removeAllPoints();
    super.setOrthogonal(bOrtho);
  }

  public void SVGWriteObject(DomDoc svgDoc, DomElement jGoElementGroup)
  {
    // Add <FlowLink> element
    if (svgDoc.JGoXMLOutputEnabled()) {
      DomElement flowLink = svgDoc.createJGoClassElement(
          "com.nwoods.jgo.examples.flower.FlowLink", jGoElementGroup);
    }

    // Have superclass add to the JGoObject group
    super.SVGWriteObject(svgDoc, jGoElementGroup);
  }

  public DomNode SVGReadObject(DomDoc svgDoc, JGoDocument jGoDoc, DomElement svgElement, DomElement jGoChildElement)
  {
    if (jGoChildElement != null) {
      // This is a <FlowLink> element
      super.SVGReadObject(svgDoc, jGoDoc, svgElement, jGoChildElement.getNextSiblingJGoClassElement());
    }
    return svgElement.getNextSibling();
  }

}