/*
 *  Copyright (c) Northwoods Software Corporation, 1998-2008. All Rights
 *  Reserved.
 *
 *  Restricted Rights: Use, duplication, or disclosure by the U.S.
 *  Government is subject to restrictions as set forth in subparagraph
 *  (c) (1) (ii) of DFARS 252.227-7013, or in FAR 52.227-19, or in FAR
 *  52.227-14 Alt. III, as applicable.
 */

package com.nwoods.jgo.examples.instrumentdemo;

import java.awt.*;
import javax.swing.*;
import com.nwoods.jgo.*;
import com.nwoods.jgo.instruments.*;

  /**
   * A vertical or horizontal meter showing the value as a bar.
   */
  public class BarMeter extends Meter {
    public BarMeter() {}

    protected AbstractGraduatedScale createScale() {
      GraduatedScaleLinear scale = new GraduatedScaleLinear();
      scale.setTickUnit(2);
      scale.setTickMajorFrequency(10);
      return scale;
    }

    protected AbstractIndicator createIndicator() {
      IndicatorBar bar = new IndicatorBar();
      bar.setActionEnabled(true);
      bar.setBrush(JGoBrush.yellow);
      return bar;
    }

    public void layoutChildren(JGoObject childchanged) {
      if (isInitializing()) return;
      super.layoutChildren(childchanged);
      GraduatedScaleLinear gsl = null;
      if (getScale() instanceof GraduatedScaleLinear) gsl = (GraduatedScaleLinear)getScale();
      if (gsl != null) {
        Rectangle r = new Rectangle(gsl.getBoundingRect());
        if (getOrientation() == OrientationHorizontal) {
          if (r.width < 40) {
            gsl.setStartPoint(new Point(r.x + r.width/10, r.y + r.height/2));
            gsl.setEndPoint(new Point(r.x + 9*r.width/10, r.y + r.height/2));
          } else {
            gsl.setStartPoint(new Point(r.x + 10, r.y + r.height/2));
            gsl.setEndPoint(new Point(r.x + r.width - 10, r.y + r.height/2));
          }
        } else {
          if (r.height < 40) {
            gsl.setStartPoint(new Point(r.x + r.width/2, r.y + r.height/10));
            gsl.setEndPoint(new Point(r.x + r.width/2, r.y + 9*r.height/10));
          } else {
            gsl.setStartPoint(new Point(r.x + r.width/2, r.y + r.height - 10));
            gsl.setEndPoint(new Point(r.x + r.width/2, r.y + 10));
          }
        }
      }
    }

    public void SVGWriteObject(DomDoc svgDoc, DomElement jGoElementGroup)
    {
      // Add <BarMeter> element
      if (svgDoc.JGoXMLOutputEnabled()) {
        DomElement Meter = svgDoc.createJGoClassElement(
            "com.nwoods.jgo.examples.instrumentdemo.BarMeter", jGoElementGroup);
      }
      // Have superclass add to the JGoObject group
      super.SVGWriteObject(svgDoc, jGoElementGroup);
    }

    public DomNode SVGReadObject(DomDoc svgDoc, JGoDocument jGoDoc, DomElement svgElement, DomElement jGoChildElement)
    {
      if (jGoChildElement != null) {
        // This is a <BarMeter> element
        super.SVGReadObject(svgDoc, jGoDoc, svgElement, jGoChildElement.getNextSiblingJGoClassElement());
      }
      return svgElement.getNextSibling();
    }

    public float getThickness() { return ((IndicatorBar)getIndicator()).getThickness(); }
    public void setThickness(float value) { ((IndicatorBar)getIndicator()).setThickness(value); }
  }
