/*
 *  Copyright (c) Northwoods Software Corporation, 1998-2008. All Rights
 *  Reserved.
 *
 *  Restricted Rights: Use, duplication, or disclosure by the U.S.
 *  Government is subject to restrictions as set forth in subparagraph
 *  (c) (1) (ii) of DFARS 252.227-7013, or in FAR 52.227-19, or in FAR
 *  52.227-14 Alt. III, as applicable.
 */

package com.nwoods.jgo.examples.instrumentdemo;

import java.awt.*;
import javax.swing.*;
import java.text.*;
import com.nwoods.jgo.*;
import com.nwoods.jgo.instruments.*;

  public class BarMeterElliptical extends Meter {
    public BarMeterElliptical() {}

    public void initialize() {
      super.initialize();
      setLabelSpot(Center);
      setLabelRelativeSpot(Center);
      setInsets(new Insets(30, 30, 30, 30));
    }

    protected JGoObject createBackground() {
      JGoObject obj = super.createBackground();
      JGoDrawable back = null;
      if (obj instanceof JGoDrawable) back = (JGoDrawable)obj;
      if (back != null) {
        back.setPen(JGoPen.white);
        back.setBrush(JGoBrush.gray);
      }
      return obj;
    }

    protected JGoText createLabel() {
      JGoText l = super.createLabel();
      if (l != null) {
        l.setText("0");
        l.setTextColor(Color.white);
        l.setAlignment(Center);
        l.setFontSize(20);
        l.setItalic(true);
      }
      return l;
    }

    protected AbstractGraduatedScale createScale() {
      GraduatedScaleElliptical scale = new GraduatedScaleElliptical();
      scale.setStartAngle(110);
      scale.setSweepAngle(320);
      scale.setTickUnit(2);
      scale.setTickMajorFrequency(5);
      scale.setPen(JGoPen.white);
      scale.setTickColor(Color.white);
      scale.getLabelTemplate().setTextColor(Color.white);
      return scale;
    }

    protected AbstractIndicator createIndicator() {
      IndicatorBarElliptical bar = new IndicatorBarElliptical();
      bar.setActionEnabled(true);
      bar.setThickness(6);
      bar.setBrush(JGoBrush.yellow);
      bar.setUpdatePartner(true);
      return bar;
    }

    public void layoutChildren(JGoObject childchanged) {
      if (isInitializing()) return;
      super.layoutChildren(childchanged);
      if (getScale() != null) {
        IndicatorBarElliptical ie = null;
        if (getIndicator() instanceof IndicatorBarElliptical) ie = (IndicatorBarElliptical)getIndicator();
        if (ie != null) {
          Rectangle srect = new Rectangle(getScale().getBoundingRect());
          float l = ie.getThickness();
          srect.grow((int)l/2, (int)l/2);
          getIndicator().setBoundingRect(srect);
        }
      }
    }

    // Keep the indicator value and the label in sync
    protected void partnerUpdate(JGoObject partner, int hint, int prevInt, Object prevVal) {
      if (hint == AbstractIndicator.ChangedValue && partner == getIndicator() && getLabel() != null) {
        myFormatter.setMaximumFractionDigits(2);
        String s = myFormatter.format(getValue());
        getLabel().setText(s);
      } else if (hint == JGoText.ChangedText && partner == getLabel() && getLabel() != null) {
        String s = getLabel().getText();
        try {
          myFormatter.setMaximumFractionDigits(2);
          double v = myFormatter.parse(s).doubleValue();
          getIndicator().setValue(v);
        } catch (ParseException ex) {
          getLabel().setText((String)prevVal);
        }
      }
    }

    public void SVGWriteObject(DomDoc svgDoc, DomElement jGoElementGroup)
    {
      // Add <BarMeterElliptical> element
      if (svgDoc.JGoXMLOutputEnabled()) {
        DomElement BarMeterElliptical = svgDoc.createJGoClassElement(
            "com.nwoods.jgo.examples.instrumentdemo.BarMeterElliptical", jGoElementGroup);
      }
      // Have superclass add to the JGoObject group
      super.SVGWriteObject(svgDoc, jGoElementGroup);
    }

    public DomNode SVGReadObject(DomDoc svgDoc, JGoDocument jGoDoc, DomElement svgElement, DomElement jGoChildElement)
    {
      if (jGoChildElement != null) {
        // This is a <BarMeterElliptical> element
        super.SVGReadObject(svgDoc, jGoDoc, svgElement, jGoChildElement.getNextSiblingJGoClassElement());
      }
      return svgElement.getNextSibling();
    }

    private NumberFormat myFormatter = NumberFormat.getNumberInstance();

    public float getThickness() { return ((IndicatorBarElliptical)getIndicator()).getThickness(); }
    public void setThickness(float value) { ((IndicatorBarElliptical)getIndicator()).setThickness(value); }

    public boolean isFillClockwise() { return ((IndicatorBarElliptical)getIndicator()).isFillClockwise(); }
    public void setFillClockwise(boolean value) { ((IndicatorBarElliptical)getIndicator()).setFillClockwise(value); }
  }
