/*
 *  Copyright (c) Northwoods Software Corporation, 1998-2008. All Rights
 *  Reserved.
 *
 *  Restricted Rights: Use, duplication, or disclosure by the U.S.
 *  Government is subject to restrictions as set forth in subparagraph
 *  (c) (1) (ii) of DFARS 252.227-7013, or in FAR 52.227-19, or in FAR
 *  52.227-14 Alt. III, as applicable.
 */

package com.nwoods.jgo.examples.instrumentdemo;

import java.awt.*;
import javax.swing.*;
import com.nwoods.jgo.*;
import com.nwoods.jgo.instruments.*;

  /**
   * Display a gradient along the bar.
   * <p>
   * The gradient only needs to be
   * reconstructed when the whole indicator/meter is resized or moved,
   * not as the value changes.
   */
  public class GradientBarMeter extends BarMeter {
    public GradientBarMeter() {}

    public JGoObject copyObject(JGoCopyEnvironment env) {
      GradientBarMeter newobj = (GradientBarMeter)super.copyObject(env);
      newobj.UpdateBrush();
      return newobj;
    }

    public void UpdateBrush() {
      GraduatedScaleLinear scale = null;
      if (getScale() instanceof GraduatedScaleLinear) scale = (GraduatedScaleLinear)getScale();
      IndicatorBar bar = null;
      if (getIndicator() instanceof IndicatorBar) bar = (IndicatorBar)getIndicator();
      if (scale != null && bar != null) {
        Point start = scale.getStartPoint();
        Point end = scale.getEndPoint();
        if (start.x != end.x || start.y != end.y) {
          bar.setBrush(new JGoBrush(new GradientPaint(start.x, start.y, Color.green,
                                                      end.x, end.y, Color.red)));
        }
      }
    }

    public void SVGWriteObject(DomDoc svgDoc, DomElement jGoElementGroup)
    {
      // Add <GradientBarMeter> element
      if (svgDoc.JGoXMLOutputEnabled()) {
        DomElement GradientBarMeter = svgDoc.createJGoClassElement(
            "com.nwoods.jgo.examples.instrumentdemo.GradientBarMeter", jGoElementGroup);
      }
      // Have superclass add to the JGoObject group
      super.SVGWriteObject(svgDoc, jGoElementGroup);
    }

    public DomNode SVGReadObject(DomDoc svgDoc, JGoDocument jGoDoc, DomElement svgElement, DomElement jGoChildElement)
    {
      if (jGoChildElement != null) {
        // This is a <GradientBarMeter> element
        super.SVGReadObject(svgDoc, jGoDoc, svgElement, jGoChildElement.getNextSiblingJGoClassElement());
      }
      UpdateBrush();
      return svgElement.getNextSibling();
    }

    // whenever this is moved or resized, rebuild the gradient brush
    protected void geometryChange(Rectangle old) {
      super.geometryChange(old);
      UpdateBrush();
    }

    public void changeValue(JGoDocumentChangedEdit e, boolean undo) {
      switch (e.getFlags()) {
        case ChangedGeometry:
          super.changeValue(e, undo);
          UpdateBrush();
          break;
        default:
          super.changeValue (e, undo);
          break;
      }
    }
  }
