/*
 *  Copyright (c) Northwoods Software Corporation, 1998-2008. All Rights
 *  Reserved.
 *
 *  Restricted Rights: Use, duplication, or disclosure by the U.S.
 *  Government is subject to restrictions as set forth in subparagraph
 *  (c) (1) (ii) of DFARS 252.227-7013, or in FAR 52.227-19, or in FAR
 *  52.227-14 Alt. III, as applicable.
 */

package com.nwoods.jgo.examples.instrumentdemo;

import java.awt.*;
import javax.swing.*;
import java.util.Random;
import com.nwoods.jgo.*;
import com.nwoods.jgo.instruments.*;

public class HourClockHand extends IndicatorNeedle {
  public HourClockHand() {}

  /**
   * The hour hand handles 24 hour values but displays only 12 hours, AM/PM,
   * on a scale from 0 to 120 (0 to 60 twice).
   */
  public double validValue(double val) {
    if (val > 120 || val < 0)
      val = val % 120;

    val = quantizeValue(val);

    return val;
  }
}
