/*
 *  Copyright (c) Northwoods Software Corporation, 1998-2008. All Rights
 *  Reserved.
 *
 *  Restricted Rights: Use, duplication, or disclosure by the U.S.
 *  Government is subject to restrictions as set forth in subparagraph
 *  (c) (1) (ii) of DFARS 252.227-7013, or in FAR 52.227-19, or in FAR
 *  52.227-14 Alt. III, as applicable.
 *
 */

package com.nwoods.jgo.examples.instrumentdemo;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.util.*;
import com.nwoods.jgo.*;
import com.nwoods.jgo.svg.*;
import com.nwoods.jgo.instruments.*;

import java.io.*;


public class InstrumentsDemoFrame
    extends JFrame
    implements com.nwoods.jgo.JGoViewListener {
  JPanel contentPane;
  JMenuBar jMenuBar1 = new JMenuBar();
  JMenu jMenuFile = new JMenu();
  JMenuItem jMenuFileExit = new JMenuItem();
  JMenu jMenuHelp = new JMenu();
  JMenuItem jMenuHelpAbout = new JMenuItem();
  ImageIcon image1;
  ImageIcon image2;
  ImageIcon image3;
  BorderLayout borderLayout1 = new BorderLayout();
  JTabbedPane jTabbedPane1 = new JTabbedPane();
  JMenu jMenuEdit = new JMenu();
  JMenuItem jMenuZoomOut = new JMenuItem();
  JMenuItem jMenuZoomIn = new JMenuItem();
  JGoView jGoScales = new JGoView();
  JGoView jGoMeters = new JGoView();
  JGoView jGoSpecial = new JGoView();
  JMenuItem jMenuZoomNormalSize = new JMenuItem();
  JMenuItem jMenuZoomToFit = new JMenuItem();
  JMenuItem jMenuPaste = new JMenuItem();
  JMenuItem jMenuCopy = new JMenuItem();
  JMenuItem jMenuCut = new JMenuItem();
  JMenuItem jMenuUndo = new JMenuItem();
  JMenuItem jMenuRedo = new JMenuItem();
  JMenuItem jMenuInspect = new JMenuItem();

  //Construct the frame
  public InstrumentsDemoFrame() {
    enableEvents(AWTEvent.WINDOW_EVENT_MASK);
    try {
      jbInit();
      // Handle various JGoView events
      jGoScales.addViewListener(this);
      jGoMeters.addViewListener(this);
      jGoSpecial.addViewListener(this);
      // Handle various keyboard commands
      jGoScales.addKeyListener(new KeyAdapter() {
        public void keyPressed(KeyEvent evt) {
          handleKeyPressed(evt);
        }
      });
      jGoMeters.addKeyListener(new KeyAdapter() {
        public void keyPressed(KeyEvent evt) {
          handleKeyPressed(evt);
        }
      });
      jGoSpecial.addKeyListener(new KeyAdapter() {
        public void keyPressed(KeyEvent evt) {
          handleKeyPressed(evt);
        }
      });

      // Populate the different views
      populateSpecial(jGoSpecial);
      this.jTabbedPane1.addTab("Special", jGoSpecial);
      populateSampleMeters(jGoMeters);
      this.jTabbedPane1.addTab("Sample Meters", jGoMeters);
      populateBasicScales(jGoScales);
      this.jTabbedPane1.addTab("Basic Scales", jGoScales);

      // Add undo-managers
      jGoScales.getDocument().setUndoManager(new JGoUndoManager() {
        public void endTransaction(String s) {
          super.endTransaction(s);
          Inspector.refresh();
        }
      }
      );
      jGoMeters.getDocument().setUndoManager(new JGoUndoManager() {
        public void endTransaction(String s) {
          super.endTransaction(s);
          Inspector.refresh();
        }
      }
      );
      jGoSpecial.getDocument().setUndoManager(new JGoUndoManager() {
        public void endTransaction(String s) {
          super.endTransaction(s);
          Inspector.refresh();
        }
      }
      );

      myTimer1Action = new AbstractAction() {
        public void actionPerformed(ActionEvent e) {
          jGoScales.getDocument().setSkipsUndoManager(true);
          jGoMeters.getDocument().setSkipsUndoManager(true);
          jGoSpecial.getDocument().setSkipsUndoManager(true);
          for (int i = 0; i < myMeters.size(); i++) {
            if (myMeters.get(i) instanceof Meter) {
              Meter meter = (Meter)myMeters.get(i);
              double old = meter.getValue();
              meter.setValue(old + meter.getScale().getRange()/100);
              if (old == meter.getValue())
                meter.setValue(meter.getScale().getMinimum());
              if (meter instanceof GaugeMeter) {
                GaugeMeter gm = (GaugeMeter)meter;
                gm.getGauge().setValue(gm.getGauge().getValue() + gm.getScale().getRange()/100);
              }
            }
          }
          JGoDocument doc = jGoSpecial.getDocument();
          JGoListPosition pos = doc.getFirstObjectPos();
          while (pos != null) {
            JGoObject obj = doc.getObjectAtPos(pos);
            // only consider top-level objects
            pos = doc.getNextObjectPosAtTop(pos);
            if (obj instanceof Tank) {
              Tank t = (Tank)obj;
              t.drain();
            }
          }
          jGoScales.getDocument().setSkipsUndoManager(false);
          jGoMeters.getDocument().setSkipsUndoManager(false);
          jGoSpecial.getDocument().setSkipsUndoManager(false);
        }
      };
      myTimer1 = new javax.swing.Timer(100, myTimer1Action);
      myTimer1.start();

      myTimer2Action = new AbstractAction() {
        public void actionPerformed(ActionEvent e) {
          JGoDocument doc = jGoSpecial.getDocument();
          doc.setSkipsUndoManager(true);
          if (myClock != null) {
            myClock.incrementTime();
          }
          doc.setSkipsUndoManager(false);
        }
      };
      myTimer2 = new javax.swing.Timer(1000, myTimer2Action);
      myTimer2.start();
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  private void populateBasicScales(JGoView view) {
    // the basic scales:
    JGoDocument doc = view.getDocument();
    GraduatedScaleLinear scale = new GraduatedScaleLinear();
    scale.setSelectable(true);
    scale.setStartPoint(new Point(40, 160));
    scale.setEndPoint(new Point(210, 45));
    scale.setTickLengthLeft(10);
    scale.setTickMajorLengthRatio(1);
    scale.setTickUnit(2.5);
    scale.setTickMajorFrequency(4);
    scale.setMinimum( -23);
    scale.setMaximum(77);
    doc.addObjectAtTail(scale);

    GraduatedScaleElliptical scale2 = new GraduatedScaleElliptical();
    scale2.setSelectable(true);
    scale2.setBoundingRect(210, 120, 100, 80);
    scale2.setStartAngle(20);
    scale2.setSweepAngle(200);
    scale2.setTickLengthLeft(10);
    scale2.setMinimum(40);
    scale2.setMaximum(150);
    doc.addObjectAtTail(scale2);

    Ruler ruler = new Ruler();
    ruler.setStartPoint(new Point(26, 300));
    ruler.setEndPoint(new Point(260, 300));
    doc.addObjectAtTail(ruler);
  }

  private void populateSampleMeters(JGoView view) {
    // various sample meters:
    JGoDocument doc = view.getDocument();

    NeedleMeter meter = new NeedleMeter();
    meter.initialize();
    meter.setBoundingRect(10, 10, 200, 110);
    meter.getScale().setMinimum(-20);
    doc.addObjectAtTail(meter);

    NeedleMeterElliptical meterellip = new NeedleMeterElliptical();
    meterellip.initialize();
    meterellip.setBoundingRect(7, 530, 201, 207);
    doc.addObjectAtTail(meterellip);

    BarMeter barmeter = new BarMeter();
    barmeter.initialize();
    barmeter.setBoundingRect(234, 11, 200, 80);
    barmeter.setValue(30);
    doc.addObjectAtTail(barmeter);

    GradientBarMeter gbarmeter = new GradientBarMeter();
    gbarmeter.initialize();
    gbarmeter.setBoundingRect(234, 105, 200, 80);
    gbarmeter.setValue(90);
    doc.addObjectAtTail(gbarmeter);

    BarMeterElliptical barmeterelli = new BarMeterElliptical();
    barmeterelli.initialize();
    barmeterelli.setBoundingRect(546, 11, 200, 200);
    barmeterelli.setValue(30);
    doc.addObjectAtTail(barmeterelli);

    SliderMeter slidemeter = new SliderMeter();
    slidemeter.initialize();
    slidemeter.setBoundingRect(450, 11, 80, 200);
    slidemeter.setValue(30);
    doc.addObjectAtTail(slidemeter);

    SliderMeterElliptical slidemeterelli = new SliderMeterElliptical();
    slidemeterelli.initialize();
    slidemeterelli.setBoundingRect(274, 539, 200, 200 + slidemeterelli.getLabel().getHeight());
    slidemeterelli.setValue(30);
    doc.addObjectAtTail(slidemeterelli);

    OverrunMeter overrun = new OverrunMeter();
    overrun.initialize();
    overrun.setBoundingRect(16, 250, 200, 200 + overrun.getLabel().getHeight());
    overrun.setValue(30);
    myMeters.add(overrun);  // continual updating of value in timer event handler
    doc.addObjectAtTail(overrun);

    GaugeMeter gauge = new GaugeMeter();
    gauge.initialize();
    gauge.setBoundingRect(266, 250, 200, 200 + gauge.getLabel().getHeight());
    myMeters.add(gauge);  // continual updating of value in timer event handler
    doc.addObjectAtTail(gauge);

    MultiPhaseMeter phasemeter = new MultiPhaseMeter();
    phasemeter.initialize();
    phasemeter.setBoundingRect(516, 250, 200, 200 + phasemeter.getLabel().getHeight());
    phasemeter.setValue(30);
    myMeters.add(phasemeter);  // continual updating of value in timer event handler
    doc.addObjectAtTail(phasemeter);

    MultiPhaseMeterElliptical phasemeterelli = new MultiPhaseMeterElliptical();
    phasemeterelli.initialize();
    phasemeterelli.setBoundingRect(766, 250, 200, 200 + phasemeterelli.getLabel().getHeight());
    phasemeterelli.setValue(30);
    myMeters.add(phasemeterelli);  // continual updating of value in Timer event handler
    doc.addObjectAtTail(phasemeterelli);

    KnobMeter knobmeter= new KnobMeter();
    knobmeter.initialize();
    knobmeter.setBoundingRect(764, 12, 200, 200 + knobmeter.getLabel().getHeight());
    knobmeter.setValue(30);
    doc.addObjectAtTail(knobmeter);
  }

  private void populateSpecial(JGoView view) {
    // special example classes:
    JGoDocument doc = view.getDocument();

    Clock clock = new Clock();
    clock.initialize();
    JGoImage img2 = new JGoImage();
    img2.setSelectable(false);
    img2.loadImage(InstrumentDemo.class.getResource("clock_face2.gif"), false);
    clock.setBackground(img2);
    clock.setBoundingRect(10, 10, 150, 150);
    Date time = new Date();
    Calendar cal = new GregorianCalendar();
    cal.setTime(time);
    clock.setTime(cal.get(Calendar.HOUR_OF_DAY), cal.get(Calendar.MINUTE), cal.get(Calendar.SECOND));
    myClock = clock;  // continual updating of displayed time in Timer event handler
    doc.addObjectAtTail(clock);

    Thermometer therm = new Thermometer();
    therm.initialize();
    therm.setBoundingRect(30, 200, 100, 250);
    doc.addObjectAtTail(therm);

    Tank tank1 = new Tank();
    tank1.initialize();
    tank1.setBoundingRect(220, 50, 70, 100);
    tank1.setValue(900);
    doc.addObjectAtTail(tank1);

    Tank tank2 = new Tank();
    tank2.initialize();
    tank2.setBoundingRect(280, 200, 70, 100);
    tank2.setValue(600);
    doc.addObjectAtTail(tank2);

    Tank tank3 = new Tank();
    tank3.initialize();
    tank3.setBoundingRect(160, 200, 70, 100);
    tank3.setValue(900);
    doc.addObjectAtTail(tank3);

    Tank tank4 = new Tank();
    tank4.initialize();
    tank4.setBoundingRect(400, 200, 70, 100);
    tank4.setValue(0);
    doc.addObjectAtTail(tank4);

    Pipe pipe1 = new Pipe();
    pipe1.setFromPort(tank1.getOutputPort());
    pipe1.setToPort(tank2.getInputPort());
    pipe1.setRate(2);
    doc.addObjectAtHead(pipe1);

    Pipe pipe2 = new Pipe();
    pipe2.setFromPort(tank1.getOutputPort());
    pipe2.setToPort(tank3.getInputPort());
    pipe2.setRate(0.5);
    doc.addObjectAtHead(pipe2);

    Pipe pipe3 = new Pipe();
    pipe3.setFromPort(tank2.getOutputPort());
    pipe3.setToPort(tank4.getInputPort());
    doc.addObjectAtHead(pipe3);

    MultiBarMeter multiMeter = new MultiBarMeter();
    multiMeter.initialize();
    multiMeter.setBoundingRect(500, 50, 400, 300);
    doc.addObjectAtTail(multiMeter);
  }

  //Component initialization
  private void jbInit() throws Exception {
//    image1 = new ImageIcon(com.nwoods.jgo.examples.instrumentdemo.
//                           InstrumentsDemoFrame.class.getResource(
//        "openFile.png"));
//    image2 = new ImageIcon(com.nwoods.jgo.examples.instrumentdemo.
//                           InstrumentsDemoFrame.class.getResource(
//        "closeFile.png"));
//    image3 = new ImageIcon(com.nwoods.jgo.examples.instrumentdemo.
//                           InstrumentsDemoFrame.class.getResource("help.png"));
    contentPane = (JPanel)this.getContentPane();
    contentPane.setLayout(borderLayout1);
    this.setSize(new Dimension(1024, 870));
    this.setTitle("Instruments Demo");
    jMenuFile.setText("File");
    jMenuFileExit.setText("Exit");
    jMenuFileExit.addActionListener(new
        InstrumentsDemoFrame_jMenuFileExit_ActionAdapter(this));
    jMenuHelp.setText("Help");
    jMenuHelpAbout.setText("About");
    jMenuHelpAbout.addActionListener(new
        InstrumentsDemoFrame_jMenuHelpAbout_ActionAdapter(this));
    contentPane.setPreferredSize(new Dimension(800, 600));
    contentPane.setRequestFocusEnabled(true);
    jTabbedPane1.setPreferredSize(new Dimension(800, 600));
    jMenuEdit.setText("Edit");
    jMenuZoomOut.setText("Zoom Out");
    jMenuZoomOut.setAccelerator(javax.swing.KeyStroke.getKeyStroke(KeyEvent.
        VK_F6, Event.SHIFT_MASK));
    jMenuZoomOut.addActionListener(new
        InstrumentsDemoFrame_jMenuZoomOut_actionAdapter(this));
    jMenuZoomIn.setText("Zoom In");
    jMenuZoomIn.setAccelerator(javax.swing.KeyStroke.getKeyStroke(KeyEvent.
        VK_F6, Event.CTRL_MASK));
    jMenuZoomIn.addActionListener(new
        InstrumentsDemoFrame_jMenuZoomIn_actionAdapter(this));
    jMenuZoomNormalSize.setText("Zoom Normal Size");
    jMenuZoomNormalSize.setAccelerator(javax.swing.KeyStroke.getKeyStroke(
        KeyEvent.VK_F6, Event.CTRL_MASK | Event.SHIFT_MASK));
    jMenuZoomNormalSize.addActionListener(new
        InstrumentsDemoFrame_jMenuZoomNormalSize_actionAdapter(this));
    jMenuZoomToFit.setText("Zoom To Fit");
    jMenuZoomToFit.setAccelerator(javax.swing.KeyStroke.getKeyStroke(KeyEvent.
        VK_F6, 0));
    jMenuZoomToFit.addActionListener(new
        InstrumentsDemoFrame_jMenuZoomToFit_actionAdapter(this));
    jMenuCut.setText("Cut");
    jMenuCut.setAccelerator(javax.swing.KeyStroke.getKeyStroke(KeyEvent.VK_X,
        Event.CTRL_MASK));
    jMenuCut.addActionListener(new InstrumentsDemoFrame_jMenuCut_actionAdapter(this));
    jMenuCopy.setText("Copy");
    jMenuCopy.setAccelerator(javax.swing.KeyStroke.getKeyStroke(KeyEvent.VK_C,
        Event.CTRL_MASK));
    jMenuCopy.addActionListener(new
                                InstrumentsDemoFrame_jMenuCopy_actionAdapter(this));
    jMenuPaste.setText("Paste");
    jMenuPaste.setAccelerator(javax.swing.KeyStroke.getKeyStroke(KeyEvent.VK_V,
        Event.CTRL_MASK));
    jMenuPaste.addActionListener(new
                                 InstrumentsDemoFrame_jMenuPaste_actionAdapter(this));
    jMenuUndo.setText("Undo");
    jMenuUndo.setAccelerator(javax.swing.KeyStroke.getKeyStroke(KeyEvent.VK_Z,
        Event.CTRL_MASK));
    jMenuUndo.addActionListener(new
                                InstrumentsDemoFrame_jMenuUndo_actionAdapter(this));
    jMenuRedo.setText("Redo");
    jMenuRedo.setAccelerator(javax.swing.KeyStroke.getKeyStroke(KeyEvent.VK_Y,
        Event.CTRL_MASK));
    jMenuRedo.addActionListener(new
                                InstrumentsDemoFrame_jMenuRedo_actionAdapter(this));
    jMenuInspect.setText("Inspect");
    jMenuInspect.setAccelerator(javax.swing.KeyStroke.getKeyStroke(KeyEvent.
        VK_ENTER, 0));
    jMenuInspect.addActionListener(new
        InstrumentsDemoFrame_jMenuInspect_actionAdapter(this));
    jMenuSVGOut.setText("Write SVG");
    jMenuSVGOut.addActionListener(new InstrumentsDemoFrame_jMenuSVGOut_actionAdapter(this));
    jMenuSVGIn.setText("Read SVG");
    jMenuSVGIn.addActionListener(new InstrumentsDemoFrame_jMenuSVGIn_actionAdapter(this));
    jMenuToggleAnimation.setText("Stop Animation");
    jMenuToggleAnimation.addActionListener(new InstrumentsDemoFrame_jMenuToggleAnimation_actionAdapter(this));
    jMenuFile.add(jMenuSVGOut);
    jMenuFile.add(jMenuSVGIn);
    jMenuFile.add(jMenuFileExit);
    jMenuHelp.add(jMenuHelpAbout);
    jMenuBar1.add(jMenuFile);
    jMenuBar1.add(jMenuEdit);
    jMenuBar1.add(jMenuHelp);
    this.setJMenuBar(jMenuBar1);
    contentPane.add(jTabbedPane1, BorderLayout.CENTER);
    jMenuEdit.add(jMenuCut);
    jMenuEdit.add(jMenuCopy);
    jMenuEdit.add(jMenuPaste);
    jMenuEdit.addSeparator();
    jMenuEdit.add(jMenuUndo);
    jMenuEdit.add(jMenuRedo);
    jMenuEdit.addSeparator();
    jMenuEdit.add(jMenuZoomOut);
    jMenuEdit.add(jMenuZoomIn);
    jMenuEdit.add(jMenuZoomNormalSize);
    jMenuEdit.add(jMenuZoomToFit);
    jMenuEdit.addSeparator();
    jMenuEdit.add(jMenuToggleAnimation);
    jMenuEdit.addSeparator();
    jMenuEdit.add(jMenuInspect);
  }

  //File | Exit action performed
  public void jMenuFileExit_actionPerformed(ActionEvent e) {
    System.exit(0);
  }

  //Help | About action performed
  public void jMenuHelpAbout_actionPerformed(ActionEvent e) {
    InstrumentsDemoFrame_AboutBox dlg = new InstrumentsDemoFrame_AboutBox(this);
    Dimension dlgSize = dlg.getPreferredSize();
    Dimension frmSize = getSize();
    Point loc = getLocation();
    dlg.setLocation( (frmSize.width - dlgSize.width) / 2 + loc.x,
                    (frmSize.height - dlgSize.height) / 2 + loc.y);
    dlg.setModal(true);
    dlg.pack();
    dlg.setVisible(true);
  }

  //Overridden so we can exit when window is closed
  protected void processWindowEvent(WindowEvent e) {
    super.processWindowEvent(e);
    if (e.getID() == WindowEvent.WINDOW_CLOSING) {
      jMenuFileExit_actionPerformed(null);
    }
  }

  void jMenuZoomOut_actionPerformed(ActionEvent e) {
    JGoView v = (JGoView)this.jTabbedPane1.getSelectedComponent();
    double newscale = Math.rint(v.getScale() * 0.9f * 100f) / 100f;
    v.setScale(newscale);
  }

  void jMenuZoomIn_actionPerformed(ActionEvent e) {
    JGoView v = (JGoView)this.jTabbedPane1.getSelectedComponent();
    double newscale = Math.rint(v.getScale() / 0.9f * 100f) / 100f;
    v.setScale(newscale);
  }

  void jMenuZoomNormalSize_actionPerformed(ActionEvent e) {
    JGoView v = (JGoView)this.jTabbedPane1.getSelectedComponent();
    double newscale = 1;
    v.setScale(newscale);
  }

  void jMenuZoomToFit_actionPerformed(ActionEvent e) {
    JGoView v = (JGoView)this.jTabbedPane1.getSelectedComponent();
    double newscale = 1;
    if (!v.getDocument().isEmpty()) {
      double extentWidth = v.getExtentSize().width;
      double printWidth = v.getPrintDocumentSize().width;
      double extentHeight = v.getExtentSize().height;
      double printHeight = v.getPrintDocumentSize().height;
      newscale = Math.min( (extentWidth / printWidth),
                          (extentHeight / printHeight));
    }
    if (newscale > 2) {
      newscale = 1;
    }
    newscale *= v.getScale();
    v.setScale(newscale);
    v.setViewPosition(0, 0);

  }

  public void viewChanged(JGoViewEvent e) {
    switch (e.getHint()) {
      case JGoViewEvent.UPDATE_ALL:
      case JGoViewEvent.SELECTION_GAINED:
      case JGoViewEvent.SELECTION_LOST: {
        JGoView myView = (JGoView)this.jTabbedPane1.getSelectedComponent();
        if (Inspector.getInspector() != null &&
            Inspector.getInspector().isVisible()) {
          Inspector.inspect(myView.getSelection().getPrimarySelection());
        }
        break; }
      case JGoViewEvent.DOUBLE_CLICKED: {
        JGoView myView = (JGoView)this.jTabbedPane1.getSelectedComponent();
        Inspector.inspect(myView.getSelection().getPrimarySelection());
        break; }
    }
  }

  void handleKeyPressed(KeyEvent evt) {
    JGoView myView = (JGoView)this.jTabbedPane1.getSelectedComponent();
    int code = evt.getKeyCode();
    if (code == KeyEvent.VK_ENTER) {
      inspectAction();
    }
    else if (code == KeyEvent.VK_DELETE) { // delete the currently selected objects
      myView.deleteSelection();
    }
    else if (code == KeyEvent.VK_HOME) { // scroll so that the top-left-most object is at the top-left corner
      Rectangle docbounds = myView.getDocument().computeBounds();
      myView.setViewPosition(docbounds.x, docbounds.y);
    }
    else if (code == KeyEvent.VK_END) { // scroll so that the bottom-right-most object is at the bottom-right corner
      Rectangle docbounds = myView.getDocument().computeBounds();
      Dimension viewsize = myView.getExtentSize();
      myView.setViewPosition(Math.max(docbounds.x,
                                      docbounds.x + docbounds.width -
                                      viewsize.width),
                             Math.max(docbounds.y,
                                      docbounds.y + docbounds.height -
                                      viewsize.height));
    }
    else if (evt.isControlDown() && code == KeyEvent.VK_A) { // select all
      myView.selectAll();
//  } else if (evt.isControlDown() && code == KeyEvent.VK_X) {  // cut
//    myView.cut();
//  } else if (evt.isControlDown() && code == KeyEvent.VK_C) {  // copy
//    myView.copy();
//  } else if (evt.isControlDown() && code == KeyEvent.VK_V) {  // paste
//    myView.paste();
//  } else if (evt.isControlDown() && code == KeyEvent.VK_Z) {  // undo
//    myView.getDocument().undo();
//  } else if (evt.isControlDown() && code == KeyEvent.VK_Y) {  // redo
//    myView.getDocument().redo();
    }
    else if (evt.isControlDown() && code == KeyEvent.VK_Q) { // quit
      System.exit(0);
    }
  }

  void inspectAction() {
    JGoView myView = (JGoView)this.jTabbedPane1.getSelectedComponent();
    Inspector.inspect(myView.getSelection().getPrimarySelection());
    JDialog inspector = Inspector.getInspector();
    if (inspector != null && !inspector.isVisible()) {
      inspector.setVisible(true);
    }
  }

  void jMenuCut_actionPerformed(ActionEvent e) {
    JGoView myView = (JGoView)this.jTabbedPane1.getSelectedComponent();
    myView.cut();
  }

  void jMenuCopy_actionPerformed(ActionEvent e) {
    JGoView myView = (JGoView)this.jTabbedPane1.getSelectedComponent();
    myView.copy();
  }

  void jMenuPaste_actionPerformed(ActionEvent e) {
    JGoView myView = (JGoView)this.jTabbedPane1.getSelectedComponent();
    myView.paste();

  }

  void jMenuUndo_actionPerformed(ActionEvent e) {
    JGoView myView = (JGoView)this.jTabbedPane1.getSelectedComponent();
    myView.getDocument().undo();
  }

  void jMenuRedo_actionPerformed(ActionEvent e) {
    JGoView myView = (JGoView)this.jTabbedPane1.getSelectedComponent();
    myView.getDocument().redo();
  }

  void jMenuInspect_actionPerformed(ActionEvent e) {
    inspectAction();

  }

  private ArrayList myMeters = new ArrayList();
  private Action myTimer1Action = null;
  private javax.swing.Timer myTimer1 = null;
  private Clock myClock = null;
  private Action myTimer2Action = null;
  private javax.swing.Timer myTimer2 = null;
  JMenuItem jMenuSVGOut = new JMenuItem();
  JMenuItem jMenuSVGIn = new JMenuItem();
  JMenuItem jMenuToggleAnimation = new JMenuItem();

  void jMenuSVGOut_actionPerformed(ActionEvent e) {
    try {
      FileOutputStream outs = new FileOutputStream("c:\\temp\\test.svg");
      DefaultDocument svgDomDoc = new DefaultDocument();
      svgDomDoc.setGenerateJGoXML(true);
      svgDomDoc.setGenerateSVG(true);
      JGoView v = (JGoView)this.jTabbedPane1.getSelectedComponent();
      svgDomDoc.SVGWriteDoc(outs, v.getDocument());
    }
    catch (Exception ex) {
    }


  }

  void jMenuSVGIn_actionPerformed(ActionEvent e) {
    try {
      JGoView v = (JGoView)this.jTabbedPane1.getSelectedComponent();
      JGoDocument jGoDoc = v.getDocument();
      FileInputStream ins = new FileInputStream("c:\\temp\\test.svg");
      DefaultDocument defaultDoc = new DefaultDocument();
      defaultDoc.SVGReadDoc(ins, jGoDoc);
      ins.close();
    }
    catch (Exception ex) {
    }

  }

  void jMenuToggleAnimation_actionPerformed(ActionEvent e) {
    if (myTimer1.isRunning()) {
      myTimer1.stop();
      myTimer2.stop();
      this.jMenuToggleAnimation.setText("Start Animation");
    }
    else {
      myTimer1.restart();
      myTimer2.restart();
      this.jMenuToggleAnimation.setText("Stop Animation");
    }
  }
}

class InstrumentsDemoFrame_jMenuFileExit_ActionAdapter
    implements ActionListener {
  InstrumentsDemoFrame adaptee;

  InstrumentsDemoFrame_jMenuFileExit_ActionAdapter(InstrumentsDemoFrame adaptee) {
    this.adaptee = adaptee;
  }

  public void actionPerformed(ActionEvent e) {
    adaptee.jMenuFileExit_actionPerformed(e);
  }
}

class InstrumentsDemoFrame_jMenuHelpAbout_ActionAdapter
    implements ActionListener {
  InstrumentsDemoFrame adaptee;

  InstrumentsDemoFrame_jMenuHelpAbout_ActionAdapter(InstrumentsDemoFrame
      adaptee) {
    this.adaptee = adaptee;
  }

  public void actionPerformed(ActionEvent e) {
    adaptee.jMenuHelpAbout_actionPerformed(e);
  }
}

class InstrumentsDemoFrame_jMenuZoomOut_actionAdapter
    implements java.awt.event.ActionListener {
  InstrumentsDemoFrame adaptee;

  InstrumentsDemoFrame_jMenuZoomOut_actionAdapter(InstrumentsDemoFrame adaptee) {
    this.adaptee = adaptee;
  }

  public void actionPerformed(ActionEvent e) {
    adaptee.jMenuZoomOut_actionPerformed(e);
  }
}

class InstrumentsDemoFrame_jMenuZoomIn_actionAdapter
    implements java.awt.event.ActionListener {
  InstrumentsDemoFrame adaptee;

  InstrumentsDemoFrame_jMenuZoomIn_actionAdapter(InstrumentsDemoFrame adaptee) {
    this.adaptee = adaptee;
  }

  public void actionPerformed(ActionEvent e) {
    adaptee.jMenuZoomIn_actionPerformed(e);
  }
}

class InstrumentsDemoFrame_jMenuZoomNormalSize_actionAdapter
    implements java.awt.event.ActionListener {
  InstrumentsDemoFrame adaptee;

  InstrumentsDemoFrame_jMenuZoomNormalSize_actionAdapter(InstrumentsDemoFrame
      adaptee) {
    this.adaptee = adaptee;
  }

  public void actionPerformed(ActionEvent e) {
    adaptee.jMenuZoomNormalSize_actionPerformed(e);
  }
}

class InstrumentsDemoFrame_jMenuZoomToFit_actionAdapter
    implements java.awt.event.ActionListener {
  InstrumentsDemoFrame adaptee;

  InstrumentsDemoFrame_jMenuZoomToFit_actionAdapter(InstrumentsDemoFrame
      adaptee) {
    this.adaptee = adaptee;
  }

  public void actionPerformed(ActionEvent e) {
    adaptee.jMenuZoomToFit_actionPerformed(e);
  }
}

class InstrumentsDemoFrame_jMenuCut_actionAdapter
    implements java.awt.event.ActionListener {
  InstrumentsDemoFrame adaptee;

  InstrumentsDemoFrame_jMenuCut_actionAdapter(InstrumentsDemoFrame adaptee) {
    this.adaptee = adaptee;
  }

  public void actionPerformed(ActionEvent e) {
    adaptee.jMenuCut_actionPerformed(e);
  }
}

class InstrumentsDemoFrame_jMenuCopy_actionAdapter
    implements java.awt.event.ActionListener {
  InstrumentsDemoFrame adaptee;

  InstrumentsDemoFrame_jMenuCopy_actionAdapter(InstrumentsDemoFrame adaptee) {
    this.adaptee = adaptee;
  }

  public void actionPerformed(ActionEvent e) {
    adaptee.jMenuCopy_actionPerformed(e);
  }
}

class InstrumentsDemoFrame_jMenuPaste_actionAdapter
    implements java.awt.event.ActionListener {
  InstrumentsDemoFrame adaptee;

  InstrumentsDemoFrame_jMenuPaste_actionAdapter(InstrumentsDemoFrame adaptee) {
    this.adaptee = adaptee;
  }

  public void actionPerformed(ActionEvent e) {
    adaptee.jMenuPaste_actionPerformed(e);
  }
}

class InstrumentsDemoFrame_jMenuUndo_actionAdapter
    implements java.awt.event.ActionListener {
  InstrumentsDemoFrame adaptee;

  InstrumentsDemoFrame_jMenuUndo_actionAdapter(InstrumentsDemoFrame adaptee) {
    this.adaptee = adaptee;
  }

  public void actionPerformed(ActionEvent e) {
    adaptee.jMenuUndo_actionPerformed(e);
  }
}

class InstrumentsDemoFrame_jMenuRedo_actionAdapter
    implements java.awt.event.ActionListener {
  InstrumentsDemoFrame adaptee;

  InstrumentsDemoFrame_jMenuRedo_actionAdapter(InstrumentsDemoFrame adaptee) {
    this.adaptee = adaptee;
  }

  public void actionPerformed(ActionEvent e) {
    adaptee.jMenuRedo_actionPerformed(e);
  }
}

class InstrumentsDemoFrame_jMenuInspect_actionAdapter
    implements java.awt.event.ActionListener {
  InstrumentsDemoFrame adaptee;

  InstrumentsDemoFrame_jMenuInspect_actionAdapter(InstrumentsDemoFrame adaptee) {
    this.adaptee = adaptee;
  }

  public void actionPerformed(ActionEvent e) {
    adaptee.jMenuInspect_actionPerformed(e);
  }
}

class InstrumentsDemoFrame_jMenuSVGOut_actionAdapter implements java.awt.event.ActionListener {
  InstrumentsDemoFrame adaptee;

  InstrumentsDemoFrame_jMenuSVGOut_actionAdapter(InstrumentsDemoFrame adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jMenuSVGOut_actionPerformed(e);
  }
}

class InstrumentsDemoFrame_jMenuSVGIn_actionAdapter implements java.awt.event.ActionListener {
  InstrumentsDemoFrame adaptee;

  InstrumentsDemoFrame_jMenuSVGIn_actionAdapter(InstrumentsDemoFrame adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jMenuSVGIn_actionPerformed(e);
  }
}

class InstrumentsDemoFrame_jMenuToggleAnimation_actionAdapter implements java.awt.event.ActionListener {
  InstrumentsDemoFrame adaptee;

  InstrumentsDemoFrame_jMenuToggleAnimation_actionAdapter(InstrumentsDemoFrame adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jMenuToggleAnimation_actionPerformed(e);
  }
}