/*
 *  Copyright (c) Northwoods Software Corporation, 1998-2008. All Rights
 *  Reserved.
 *
 *  Restricted Rights: Use, duplication, or disclosure by the U.S.
 *  Government is subject to restrictions as set forth in subparagraph
 *  (c) (1) (ii) of DFARS 252.227-7013, or in FAR 52.227-19, or in FAR
 *  52.227-14 Alt. III, as applicable.
 */

package com.nwoods.jgo.examples.instrumentdemo;

import java.awt.*;
import java.awt.geom.*;
import javax.swing.*;
import java.text.*;
import com.nwoods.jgo.*;
import com.nwoods.jgo.instruments.*;

  public class LinearGradientCylinder extends JGoCylinder {
    public LinearGradientCylinder() {}

    // whenever this is moved or resized, rebuild the gradient brush
    protected void geometryChange(Rectangle old) {
      super.geometryChange(old);
      setBrush(null);
    }

    public JGoBrush getBrush() {
      JGoBrush b = super.getBrush();
      if (b == null) {
        Rectangle rect = getBoundingRect();
        b = new JGoBrush(new GradientPaint(rect.x, rect.y + rect.height/2, getStartColor(),
                                           rect.x + rect.width, rect.y + rect.height/2, getEndColor()));
        setBrush(b);
      }
      return b;
    }

    public Color getStartColor() { return myStartColor; }
    public void setStartColor(Color value) {
      Color old = myStartColor;
      if (old != value) {
        myStartColor = value;
        setBrush(null);
        update(ChangedStartColor, 0, old);
      }
    }

    public Color getEndColor() { return myEndColor; }
    public void setEndColor(Color value) {
      Color old = myEndColor;
      if (old != value) {
        myEndColor = value;
        setBrush(null);
        update(ChangedEndColor, 0, old);
      }
    }

    public void copyNewValueForRedo(JGoDocumentChangedEdit e) {
      switch (e.getFlags()) {
        case ChangedStartColor:
          e.setNewValue(getStartColor());
          return;
        case ChangedEndColor:
          e.setNewValue(getEndColor());
          return;
        default:
          super.copyNewValueForRedo(e);
          return;
      }
    }

    public void changeValue(JGoDocumentChangedEdit e, boolean undo) {
      switch (e.getFlags()) {
        case ChangedGeometry:
          super.changeValue(e, undo);
          setBrush(null);
          break;
        case ChangedStartColor:
          setStartColor((Color)e.getValue(undo));
          break;
        case ChangedEndColor:
          setEndColor((Color)e.getValue(undo));
          break;
        default:
          super.changeValue (e, undo);
          break;
      }
    }

    public void SVGWriteObject(DomDoc svgDoc, DomElement jGoElementGroup) {
      // Add <LinearGradientCylinder> element
      if (svgDoc.JGoXMLOutputEnabled()) {
        DomElement LinearGradientCylinder = svgDoc.createJGoClassElement(
            "com.nwoods.jgo.examples.instrumentdemo.LinearGradientCylinder", jGoElementGroup);
      }
      // Have superclass add to the JGoObject group
      super.SVGWriteObject(svgDoc, jGoElementGroup);
    }

    public DomNode SVGReadObject(DomDoc svgDoc, JGoDocument jGoDoc,
                                 DomElement svgElement,
                                 DomElement jGoChildElement) {
      if (jGoChildElement != null) {
        // This is a <LinearGradientCylinder> element
        super.SVGReadObject(svgDoc, jGoDoc, svgElement,
                            jGoChildElement.getNextSiblingJGoClassElement());
      }
      return svgElement.getNextSibling();
    }

    public static final int ChangedStartColor = 12412;
    public static final int ChangedEndColor = 12413;

    private Color myStartColor = Color.white;
    private Color myEndColor = Color.gray;
  }
