/*
 *  Copyright (c) Northwoods Software Corporation, 1998-2008. All Rights
 *  Reserved.
 *
 *  Restricted Rights: Use, duplication, or disclosure by the U.S.
 *  Government is subject to restrictions as set forth in subparagraph
 *  (c) (1) (ii) of DFARS 252.227-7013, or in FAR 52.227-19, or in FAR
 *  52.227-14 Alt. III, as applicable.
 */

package com.nwoods.jgo.examples.instrumentdemo;

import java.awt.*;
import javax.swing.*;
import java.util.Random;
import com.nwoods.jgo.*;
import com.nwoods.jgo.instruments.*;

public class MultiBarMeter extends MultipleIndicatorMeter {
    public MultiBarMeter() {}

    public void initialize() {
      super.initialize();
      Random rand = new Random();
      for (int i=0; i < 3; i++) {
        IndicatorBar ind = new IndicatorBar();
        if (i == 0)
          ind.setBrush(JGoBrush.green);
        else if (i == 1)
          ind.setBrush(JGoBrush.yellow);
        else if (i == 2)
          ind.setBrush(JGoBrush.blue);
        ind.setScale(getScale());
        ind.setActionEnabled(true);
        ind.setValue(rand.nextDouble()*100);
        addIndicator(ind);
      }
    }

    /**
     * Method for creating an instance of the meter's standard scale.
     */
    protected AbstractGraduatedScale createScale() {
      GraduatedScaleLinear scale = new GraduatedScaleLinear();
      scale.setLabelStyle(AbstractGraduatedScale.LabelStyleLeft);
      scale.setTickMajorLengthRatio(1);
      scale.setTickUnit(5);
      scale.setTickMajorFrequency(2);
      scale.setTickLengthLeft(0);
      return scale;
    }

    public void layoutChildren(JGoObject childchanged) { 
      if (isInitializing()) return;
      if (childchanged == getScale() && getScale() != null)
        return;
      super.layoutChildren(childchanged);
      Rectangle rect = new Rectangle(getBoundingRect());
      rect.grow(-rect.width/10, -rect.height/10);

      GraduatedScaleLinear scale = null;
      if (getScale() instanceof GraduatedScaleLinear) scale = (GraduatedScaleLinear)getScale();
      if (scale != null) {
        scale.setBoundingRect(rect);
        scale.setStartPoint(new Point(rect.x, rect.y + rect.height));
        scale.setEndPoint(new Point(rect.x, rect.y));
        scale.setTickLengthRight(rect.width);
      }
      
      float separation = ((float)rect.width)/(getIndicatorCount()+1);
      for (int i=0; i < getIndicatorCount(); i++) {
        IndicatorBar ind = null;
        if (getIndicator(i) instanceof IndicatorBar) ind = (IndicatorBar)getIndicator(i);
        if (ind != null) {
          ind.setBoundingRect(rect);
          ind.setStartOffset(new Dimension((int)(separation*(i+1)), 0));
          ind.setThickness(separation/2);
        }
      }
    }
  }
