/*
 *  Copyright (c) Northwoods Software Corporation, 1998-2008. All Rights
 *  Reserved.
 *
 *  Restricted Rights: Use, duplication, or disclosure by the U.S.
 *  Government is subject to restrictions as set forth in subparagraph
 *  (c) (1) (ii) of DFARS 252.227-7013, or in FAR 52.227-19, or in FAR
 *  52.227-14 Alt. III, as applicable.
 */

package com.nwoods.jgo.examples.instrumentdemo;

import java.awt.*;
import javax.swing.*;
import com.nwoods.jgo.*;
import com.nwoods.jgo.instruments.*;

public class MultiPhaseMeter extends Meter {
    public MultiPhaseMeter() {}

    protected AbstractGraduatedScale createScale() {
      GraduatedScaleLinear scale = new GraduatedScaleLinear();
      scale.setTickUnit(2);
      scale.setTickMajorFrequency(10);
      return scale;
    }

    protected AbstractIndicator createIndicator() {
      IndicatorBar bar = new IndicatorBar();
      bar.setActionEnabled(true);
      bar.setThickness(6);
      bar.addPhase(new Phase(10, 40, Color.green));
      bar.addPhase(new Phase(55, 70, Color.yellow));
      bar.addPhase(new Phase(80, 95, Color.blue));
      return bar;
    }

    public void layoutChildren(JGoObject childchanged) { 
      if (isInitializing()) return;
      super.layoutChildren(childchanged);
      GraduatedScaleLinear scale = null;
      if (getScale() instanceof GraduatedScaleLinear) scale = (GraduatedScaleLinear)getScale();
      if (scale != null) {
        Rectangle r = new Rectangle(scale.getBoundingRect());
        scale.setStartPoint(new Point(r.x + r.width/10, r.y + r.height/4));
        scale.setEndPoint(new Point(r.x + 9*r.width/10, r.y + 3*r.height/4));
      }
    }
  }
