/*
 *  Copyright (c) Northwoods Software Corporation, 1998-2008. All Rights
 *  Reserved.
 *
 *  Restricted Rights: Use, duplication, or disclosure by the U.S.
 *  Government is subject to restrictions as set forth in subparagraph
 *  (c) (1) (ii) of DFARS 252.227-7013, or in FAR 52.227-19, or in FAR
 *  52.227-14 Alt. III, as applicable.
 */

package com.nwoods.jgo.examples.instrumentdemo;

import java.awt.*;
import javax.swing.*;
import com.nwoods.jgo.*;
import com.nwoods.jgo.instruments.*;

public class MultiPhaseMeterElliptical extends Meter {
    public MultiPhaseMeterElliptical() {}

    public void initialize() {
      super.initialize();
      int bot = 30;
      if (getLabel() != null)
        bot += getLabel().getHeight();
      this.setInsets(new Insets(30, 30, bot, 30));
    }

    protected AbstractGraduatedScale createScale() {
      GraduatedScaleElliptical scale = new GraduatedScaleElliptical();
      scale.setStartAngle(110);
      scale.setSweepAngle(320);
      scale.setMaximum(120);
      scale.setTickUnit(2);
      scale.setTickMajorFrequency(5);
      return scale;
    }

    protected AbstractIndicator createIndicator() {
      IndicatorBarElliptical bar = new IndicatorBarElliptical();
      bar.setActionEnabled(true);
      bar.addPhase(new Phase(0, 55, Color.green));
      bar.addPhase(new Phase(55, 75, Color.yellow));
      bar.addPhase(new Phase(75, 100, Color.red));
      return bar;
    }
  }
