/*
 *  Copyright (c) Northwoods Software Corporation, 1998-2008. All Rights
 *  Reserved.
 *
 *  Restricted Rights: Use, duplication, or disclosure by the U.S.
 *  Government is subject to restrictions as set forth in subparagraph
 *  (c) (1) (ii) of DFARS 252.227-7013, or in FAR 52.227-19, or in FAR
 *  52.227-14 Alt. III, as applicable.
 */

package com.nwoods.jgo.examples.instrumentdemo;

import java.awt.*;
import javax.swing.*;
import com.nwoods.jgo.*;
import com.nwoods.jgo.instruments.*;

  public class NeedleMeter extends Meter {
    public NeedleMeter() {}

    protected AbstractGraduatedScale createScale() {
      GraduatedScaleLinear scale = new GraduatedScaleLinear();
      scale.setTickUnit(2);
      scale.setTickMajorFrequency(10);
      return scale;
    }

    protected AbstractIndicator createIndicator() {
      IndicatorNeedle needle = new IndicatorNeedle();
      needle.setActionEnabled(true);
      needle.setConstantLength(true);
      needle.setPen(JGoPen.red);
      return needle;
    }

    public void layoutChildren(JGoObject childchanged) {
      if (isInitializing()) return;
      super.layoutChildren(childchanged);
      GraduatedScaleLinear gsl = null;
      if (getScale() instanceof GraduatedScaleLinear) gsl = (GraduatedScaleLinear)getScale();
      if (gsl != null) {
        Rectangle r = new Rectangle(gsl.getBoundingRect());
        if (getOrientation() == OrientationHorizontal) {
          if (r.width < 40) {
            gsl.setStartPoint(new Point(r.x + r.width/10, r.y + r.height/3));
            gsl.setEndPoint(new Point(r.x + 9*r.width/10, r.y + r.height/3));
          } else {
            gsl.setStartPoint(new Point(r.x+10,         r.y + r.height/3));
            gsl.setEndPoint(new Point(r.x + r.width-10, r.y + r.height/3));
          }
        } else {
          if (r.height < 40) {
            gsl.setStartPoint(new Point(r.x + 2*r.width/3, r.y + r.height/10));
            gsl.setEndPoint(new Point(r.x + 2*r.width/3, r.y + 9*r.height/10));
          } else {
            gsl.setStartPoint(new Point(r.x + 2*r.width/3, r.y + r.height - 10));
            gsl.setEndPoint(new Point(r.x + 2*r.width/3, r.y + 10));
          }
        }
      }
      IndicatorNeedle ineedle = null;
      if (getIndicator() instanceof IndicatorNeedle) ineedle = (IndicatorNeedle)getIndicator();
      if (ineedle != null) {
        Rectangle r = new Rectangle(ineedle.getBoundingRect());
        if (getOrientation() == OrientationHorizontal) {
          ineedle.setLength(r.height);
          ineedle.setPivotPoint(new Point(r.x + r.width/2, r.y + r.height));
        } else {
          ineedle.setLength(r.width);
          ineedle.setPivotPoint(new Point(r.x, r.y + r.height/2));
        }
      }
    }

    public void SVGWriteObject(DomDoc svgDoc, DomElement jGoElementGroup)
    {
      // Add <NeedleMeter> element
      if (svgDoc.JGoXMLOutputEnabled()) {
        DomElement Meter = svgDoc.createJGoClassElement(
            "com.nwoods.jgo.examples.instrumentdemo.NeedleMeter", jGoElementGroup);
      }
      // Have superclass add to the JGoObject group
      super.SVGWriteObject(svgDoc, jGoElementGroup);
    }

    public DomNode SVGReadObject(DomDoc svgDoc, JGoDocument jGoDoc, DomElement svgElement, DomElement jGoChildElement)
    {
      if (jGoChildElement != null) {
        // This is a <NeedleMeter> element
        super.SVGReadObject(svgDoc, jGoDoc, svgElement, jGoChildElement.getNextSiblingJGoClassElement());
      }
      return svgElement.getNextSibling();
    }

    public boolean isConstantLength() { return ((IndicatorNeedle)getIndicator()).isConstantLength(); }
    public void setConstantLength(boolean value) { ((IndicatorNeedle)getIndicator()).setConstantLength(value); }

    public float getLength() { return ((IndicatorNeedle)getIndicator()).getLength(); }
    public void setLength(float value) { ((IndicatorNeedle)getIndicator()).setLength(value); }

    public float getThickness() { return ((IndicatorNeedle)getIndicator()).getThickness(); }
    public void setThickness(float value) { ((IndicatorNeedle)getIndicator()).setThickness(value); }

    public int getStyle() { return ((IndicatorNeedle)getIndicator()).getStyle(); }
    public void setStyle(int value) { ((IndicatorNeedle)getIndicator()).setStyle(value); }
  }
