/*
 *  Copyright (c) Northwoods Software Corporation, 1998-2008. All Rights
 *  Reserved.
 *
 *  Restricted Rights: Use, duplication, or disclosure by the U.S.
 *  Government is subject to restrictions as set forth in subparagraph
 *  (c) (1) (ii) of DFARS 252.227-7013, or in FAR 52.227-19, or in FAR
 *  52.227-14 Alt. III, as applicable.
 */

package com.nwoods.jgo.examples.instrumentdemo;

import java.awt.*;
import javax.swing.*;
import com.nwoods.jgo.*;
import com.nwoods.jgo.instruments.*;

public class NeedleMeterElliptical extends Meter {
    public NeedleMeterElliptical() {}

    public void initialize() {
      super.initialize();
      this.setLabelRelativeSpot(TopMiddle);
    }

    protected JGoObject createBackground() {
      JGoEllipse e = new JGoEllipse();
      e.setSelectable(false);
      e.setPen(JGoPen.make(JGoPen.SOLID, 3, Color.gray));
      e.setBrush(JGoBrush.make(JGoBrush.SOLID, new Color(0, 0, 127)));  // darkBlue
      return e;
    }

    protected AbstractGraduatedScale createScale() {
      GraduatedScaleElliptical scale = new GraduatedScaleElliptical();
      scale.setPen(JGoPen.make(JGoPen.SOLID, 2, Color.gray));
      scale.setTickColor(Color.orange);
      scale.setTickWidth(2);
      scale.setTickMajorWidth(3);
      scale.getLabelTemplate().setTextColor(Color.orange);
      scale.getLabelTemplate().setBold(true);
      scale.setStartAngle(110);
      scale.setSweepAngle(320);
      scale.setMaximum(100.0);
      scale.setMinimum(0);
      scale.setTickUnit(5);
      scale.setTickMajorFrequency(4);
      scale.setTickLengthLeft(0);
      scale.setLabelStyle(AbstractGraduatedScale.LabelStyleRight);
      return scale;
    }

    protected AbstractIndicator createIndicator() {
      IndicatorNeedle needle = new IndicatorNeedle();
      needle.setActionEnabled(true);
      needle.setConstantLength(true);
      needle.setStyle(IndicatorNeedle.StyleKite);
      needle.setBrush(JGoBrush.orange);
      needle.setThickness(12);
      needle.setQuantized(false);
      needle.setQuantizeUnit(5);
      return needle;
    }

    public void layoutChildren(JGoObject childchanged) { 
      if (isInitializing()) return;
      super.layoutChildren(childchanged);

      IndicatorNeedle ineedle = null;
      if (getIndicator() instanceof IndicatorNeedle) ineedle = (IndicatorNeedle)getIndicator();
      if (ineedle != null && getScale() != null) {
        JGoObject scale = getScale();
        Point p = new Point(scale.getLeft() + scale.getWidth()/2, scale.getTop() + scale.getHeight()/2);
        ineedle.setPivotPoint(p);
        if (isConstantLength())
          ineedle.setLength(Math.min(scale.getWidth()/2, scale.getHeight()/2));
      }
    }

    public boolean isConstantLength() { return ((IndicatorNeedle)getIndicator()).isConstantLength(); }
    public void setConstantLength(boolean value) { ((IndicatorNeedle)getIndicator()).setConstantLength(value); }

    public float getLength() { return ((IndicatorNeedle)getIndicator()).getLength(); }
    public void setLength(float value) { ((IndicatorNeedle)getIndicator()).setLength(value); }

    public float getThickness() { return ((IndicatorNeedle)getIndicator()).getThickness(); }
    public void setThickness(float value) { ((IndicatorNeedle)getIndicator()).setThickness(value); }

    public int getStyle() { return ((IndicatorNeedle)getIndicator()).getStyle(); }
    public void setStyle(int value) { ((IndicatorNeedle)getIndicator()).setStyle(value); }
  }
