/*
 *  Copyright (c) Northwoods Software Corporation, 1998-2008. All Rights
 *  Reserved.
 *
 *  Restricted Rights: Use, duplication, or disclosure by the U.S.
 *  Government is subject to restrictions as set forth in subparagraph
 *  (c) (1) (ii) of DFARS 252.227-7013, or in FAR 52.227-19, or in FAR
 *  52.227-14 Alt. III, as applicable.
 */

package com.nwoods.jgo.examples.instrumentdemo;

import java.awt.*;
import javax.swing.*;
import java.util.Random;
import com.nwoods.jgo.*;
import com.nwoods.jgo.instruments.*;

public class OverrunIndicator extends IndicatorBarElliptical {
  public OverrunIndicator() {}

  public double validValue(double val) {
    GraduatedScale scale = getScale();
    if (val > 3*scale.getMaximum())
      val = 3*scale.getMaximum();
    else if (val < scale.getMinimum())
      val = scale.getMinimum();
    val = quantizeValue(val);
    return val;
  }
  public void SVGWriteObject(DomDoc svgDoc, DomElement jGoElementGroup)
  {
    // Add <OverrunIndicator> element
    if (svgDoc.JGoXMLOutputEnabled()) {
      DomElement OverrunIndicator = svgDoc.createJGoClassElement(
          "com.nwoods.jgo.examples.instrumentdemo.OverrunIndicator", jGoElementGroup);
    }
    // Have superclass add to the JGoObject group
    super.SVGWriteObject(svgDoc, jGoElementGroup);
  }

  public DomNode SVGReadObject(DomDoc svgDoc, JGoDocument jGoDoc, DomElement svgElement, DomElement jGoChildElement)
  {
    if (jGoChildElement != null) {
      // This is a <OverrunIndicator> element
      super.SVGReadObject(svgDoc, jGoDoc, svgElement, jGoChildElement.getNextSiblingJGoClassElement());
    }
    return svgElement.getNextSibling();
  }

}
