/*
 *  Copyright (c) Northwoods Software Corporation, 1998-2008. All Rights
 *  Reserved.
 *
 *  Restricted Rights: Use, duplication, or disclosure by the U.S.
 *  Government is subject to restrictions as set forth in subparagraph
 *  (c) (1) (ii) of DFARS 252.227-7013, or in FAR 52.227-19, or in FAR
 *  52.227-14 Alt. III, as applicable.
 */

package com.nwoods.jgo.examples.instrumentdemo;

import java.awt.*;
import javax.swing.*;
import java.util.Random;
import com.nwoods.jgo.*;
import com.nwoods.jgo.instruments.*;

public class OverrunMeter extends Meter {
  public OverrunMeter() {}

  public void initialize() {
    super.initialize();
    int bot = 30;
    if (getLabel() != null)
      bot += getLabel().getHeight();
    setInsets(new Insets(30, 30, bot, 30));
  }

  protected AbstractGraduatedScale createScale() {
    GraduatedScaleElliptical scale = new GraduatedScaleElliptical();
    scale.setStartAngle(180);
    scale.setSweepAngle(360);
    scale.setTickUnit(5);
    scale.setTickMajorFrequency(2);

    scale.setLabelStyle(AbstractGraduatedScale.LabelStyleLeft);
    return scale;
  }

  protected AbstractIndicator createIndicator() {
    OverrunIndicator bar = new OverrunIndicator();
    bar.setActionEnabled(true);

    bar.addPhase(new Phase(0, 100, Color.green));
    bar.addPhase(new Phase(100, 200, Color.blue));
    bar.addPhase(new Phase(200, 300, Color.red));

    return bar;
  }


  public void layoutChildren(JGoObject childchanged) {
    if (isInitializing()) return;
    super.layoutChildren(childchanged);
    if (getScale() != null) {
      IndicatorNeedle ineedle = null;
      if (getIndicator() instanceof IndicatorNeedle) ineedle = (IndicatorNeedle)getIndicator();
      if (ineedle != null) {
        JGoObject scale = getScale();
        ineedle.setPivotPoint(new Point(scale.getLeft() + scale.getWidth()/2, scale.getTop() + scale.getHeight()/2));
        if (((IndicatorNeedle)getIndicator()).isConstantLength())
          ineedle.setLength(Math.min(scale.getWidth()/2, scale.getHeight()/2));
      }
    }
  }

  public void SVGWriteObject(DomDoc svgDoc, DomElement jGoElementGroup)
  {
    // Add <OverrunMeter> element
    if (svgDoc.JGoXMLOutputEnabled()) {
      DomElement OverrunMeter = svgDoc.createJGoClassElement(
          "com.nwoods.jgo.examples.instrumentdemo.OverrunMeter", jGoElementGroup);
    }
    // Have superclass add to the JGoObject group
    super.SVGWriteObject(svgDoc, jGoElementGroup);
  }

  public DomNode SVGReadObject(DomDoc svgDoc, JGoDocument jGoDoc, DomElement svgElement, DomElement jGoChildElement)
  {
    if (jGoChildElement != null) {
      // This is a <OverrunMeter> element
      super.SVGReadObject(svgDoc, jGoDoc, svgElement, jGoChildElement.getNextSiblingJGoClassElement());
    }
    return svgElement.getNextSibling();
  }

}
