/*
 *  Copyright (c) Northwoods Software Corporation, 1998-2008. All Rights
 *  Reserved.
 *
 *  Restricted Rights: Use, duplication, or disclosure by the U.S.
 *  Government is subject to restrictions as set forth in subparagraph
 *  (c) (1) (ii) of DFARS 252.227-7013, or in FAR 52.227-19, or in FAR
 *  52.227-14 Alt. III, as applicable.
 */

package com.nwoods.jgo.examples.instrumentdemo;

import java.awt.*;
import javax.swing.*;
import com.nwoods.jgo.*;
import com.nwoods.jgo.instruments.*;

	/**
	 * A simple ruler, showing centimeters or inches.
	 */
  public class Ruler extends GraduatedScaleLinear {
    public Ruler() {
      setSelectable(true);
      setMinimum(0);
      setTickBase(0);
      setTickUnit(0.1);
      setTickMajorFrequency(10);
      setTickMajorWidth(0);
      setTickLengthLeft(8);
      setTickLengthRight(0);
      setLabelFormat("{0,number}");
//      Bitmap bm = new Bitmap(10, 10);
//      Graphics g = Graphics.FromImage(bm);
//      g.PageUnit = GraphicsUnit.Pixel;
//???      myDpiX = g.DpiX;
//      g.Dispose();
    }

    public JGoObject copyObject(JGoCopyEnvironment env) {
      Ruler newobj = (Ruler)super.copyObject(env);
      newobj.myMetric = myMetric;
      return newobj;
    }

    protected Rectangle computeBoundingRect() {
      Rectangle rect = super.computeBoundingRect();
      UpdateMaximum();
      return rect;
    }

    private void UpdateMaximum() {
      double len = getLength();
      if (isMetric()) {
        setMaximum(len/(myDpiX/2.54));  // per centimeter
      } else {
        setMaximum(len/(myDpiX));
      }
    }

    public boolean isMetric() { return myMetric; }
    public void setMetric(boolean value) {
      boolean old = myMetric;
      if (old != value) {
        myMetric = value;
        update(ChangedMetric, (old ? 1 : 0), null);
        if (value) {
          this.setTickUnit(0.1);
          this.setTickMajorFrequency(10);
          UpdateMaximum();
        } else {
          this.setTickUnit(0.125);
          this.setTickMajorFrequency(8);
          UpdateMaximum();
        }
      }
    }

    public boolean doMouseDblClick(int modifiers, Point dc, Point vc, JGoView view) {
      setMetric(!isMetric());
      return true;
    }

    public void copyNewValueForRedo(JGoDocumentChangedEdit e) {
      switch (e.getFlags()) {
        case ChangedMetric:
          e.setNewValueInt(isMetric() ? 1 : 0);
          return;
        default:
          super.copyNewValueForRedo(e);
          return;
      }
    }

    public void changeValue(JGoDocumentChangedEdit e, boolean undo) {
      switch (e.getFlags()) {
        case ChangedMetric:
          setMetric(e.getValueInt(undo) == 1 ? true : false);
          return;
        default:
          super.changeValue(e, undo);
          return;
      }
    }

    public static final int ChangedMetric = 15101;

    transient private double myDpiX = 96;
    private boolean myMetric = true;
  }
