/*
 *  Copyright (c) Northwoods Software Corporation, 1998-2008. All Rights
 *  Reserved.
 *
 *  Restricted Rights: Use, duplication, or disclosure by the U.S.
 *  Government is subject to restrictions as set forth in subparagraph
 *  (c) (1) (ii) of DFARS 252.227-7013, or in FAR 52.227-19, or in FAR
 *  52.227-14 Alt. III, as applicable.
 */

package com.nwoods.jgo.examples.instrumentdemo;

import java.awt.*;
import javax.swing.*;
import com.nwoods.jgo.*;
import com.nwoods.jgo.instruments.*;

public class SliderMeterElliptical extends Meter {
    public SliderMeterElliptical() {}

    public void initialize() {
      super.initialize();
      if (getLabel() != null) {
        Insets old = getInsets();
        Insets ins = new Insets(old.top, old.left, old.bottom + getLabel().getHeight(), old.right);
        setInsets(ins);
      }
    }

    protected JGoObject createBackground() {
      JGoRoundRect r = new JGoRoundRect();
      r.setSelectable(false);
      r.setBrush(JGoBrush.gray);
      return r;
    }

    protected AbstractGraduatedScale createScale() {
      GraduatedScaleElliptical scale = new GraduatedScaleElliptical();
      scale.setStartAngle(70);
      scale.setSweepAngle(-320);
      scale.setTickUnit(2);
      scale.setTickMajorFrequency(10);
      return scale;
    }

    protected AbstractIndicator createIndicator() {
      IndicatorSliderElliptical slide = new IndicatorSliderElliptical();
      slide.setActionEnabled(true);
      slide.setDimensions(new Dimension(20, 4));
      return slide;
    }

    public int getIndicatorStyle() { return ((IndicatorSlider)getIndicator()).getStyle(); }
    public void setIndicatorStyle(int value) { ((IndicatorSlider)getIndicator()).setStyle(value); }
  }
