/*
 *  Copyright (c) Northwoods Software Corporation, 2000-2008. All Rights
 *  Reserved.
 *
 *  Restricted Rights: Use, duplication, or disclosure by the U.S.
 *  Government is subject to restrictions as set forth in subparagraph
 *  (c) (1) (ii) of DFARS 252.227-7013, or in FAR 52.227-19, or in FAR
 *  52.227-14 Alt. III, as applicable.
 *
 */ 
 
package com.nwoods.jgo.examples.layoutdemo;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Iterator;
import java.util.LinkedList;
import com.nwoods.jgo.layout.JGoLayeredDigraphAutoLayout;
import com.nwoods.jgo.layout.JGoNetwork;
import com.nwoods.jgo.layout.JGoNetworkLink;
import com.nwoods.jgo.layout.JGoNetworkNode;
import com.nwoods.jgo.layout.JGoLayeredDigraphAutoLayoutLinkData;
import com.nwoods.jgo.JGoPort;
import com.nwoods.jgo.JGoLink;
import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoSelection;
import com.nwoods.jgo.JGoView;

public class SimpleLDAL extends JGoLayeredDigraphAutoLayout
{
  public SimpleLDAL() {}

  public SimpleLDAL(JGoLayeredDigraphAutoLayout layout) {
    super(layout);
    if (layout instanceof SimpleLDAL) {
      SimpleLDAL slayout = (SimpleLDAL)layout;
      setApp(slayout.myApp);
    }
  }
  
  public int getLinkMinLength(JGoNetworkLink pLink)
  {
    JGoNetworkNode pFromNode = pLink.getFromNode();
    JGoNetworkNode pToNode = pLink.getToNode();
    
    if ((pFromNode.getJGoObject() != null) && (pToNode.getJGoObject() != null)) {
      Color fromColor = ((BasicLayoutNode)(pFromNode.getJGoObject())).getColor();
      Color toColor = ((BasicLayoutNode)(pToNode.getJGoObject())).getColor();
      
      if (fromColor == toColor) {
        return 1 * super.getLinkMinLength(pLink);
      } else {
        return 2 * super.getLinkMinLength(pLink);
      }
    }
    
    return super.getLinkMinLength(pLink);
  }

  public void performLayout() {
    if (mySubNetLayout) {
      JGoView view = myApp.getCurrentView();

      int areaX = 10;
      JGoNetwork[] subnets = getNetwork().splitIntoSubNetworks();
      for (int i = 0; i < subnets.length; i++) {
        JGoNetwork subnet = (JGoNetwork)subnets[i];
        SimpleLDAL sublayout = new SimpleLDAL(this);
        sublayout.mySubNetLayout = false;
        sublayout.setNetwork(subnet);
        sublayout.performLayout();

        // move subnetwork to the right of the previously laid out subnetwork
        JGoSelection sel = subnet.getNodesAndLinks(null);
        Rectangle area = JGoDocument.computeBounds(sel);
        view.moveSelection(sel, 0, areaX - area.x, 0, JGoView.EventMouseUp);
        areaX += area.width + 100;
      }

      // arrange and move all the singleton nodes
      super.performLayout();
      JGoSelection sel2 = getNetwork().getNodesAndLinks(null);
      Rectangle area2 = JGoDocument.computeBounds(sel2);
      view.moveSelection(sel2, 0, areaX - area2.x, 0, JGoView.EventMouseUp);
    } else {
      super.performLayout();
    }
  }
  
  public void progressUpdate(double progress)
  {
    if(progress == 1.0)
      myApp.setStatus("Simple Layered Digraph Auto-Layout: 100% done.");
    else
      myApp.setStatus("Simple Layered Digraph Auto-Layout: " + (100 * progress) + "% done.");
  }

  public LayoutDemo getApp() { return myApp; }
  public void setApp(LayoutDemo app) { myApp = app; }
  
  private LayoutDemo myApp = null;
  private boolean mySubNetLayout = true;
}