/*
 *  Copyright (c) Northwoods Software Corporation, 1998-2008. All Rights
 *  Reserved.
 *
 *  Restricted Rights: Use, duplication, or disclosure by the U.S.
 *  Government is subject to restrictions as set forth in subparagraph
 *  (c) (1) (ii) of DFARS 252.227-7013, or in FAR 52.227-19, or in FAR
 *  52.227-14 Alt. III, as applicable.
 *
 */

package com.nwoods.jgo.examples.layoutdemo;

import java.awt.*;
import javax.swing.*;
import java.awt.event.*;
import com.nwoods.jgo.*;
import com.nwoods.jgo.layout.*;

/**
 * <p>Title: </p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2007</p>
 * <p>Company: </p>
 * @author not attributable
 * @version 1.0
 */

public class TreeDialog extends JDialog {
  JPanel panel1 = new JPanel();
  JButton CancelButton = new JButton();
  JButton OKButton = new JButton();

  public TreeDialog(Frame frame, String title, boolean modal, DemoView view) {
    super(frame, title, modal);
    try {
      myView = view;
      jbInit();
      pack();
    }
    catch(Exception ex) {
      ex.printStackTrace();
    }
  }

  public TreeDialog() {
    this(null, "", false, null);
  }
  private void jbInit() throws Exception {
    jLabel5.setText("Maximum Tree Size");
    jLabel5.setBounds(new Rectangle(241, 20, 141, 18));
    jPanel3.setBorder(BorderFactory.createLineBorder(Color.black));
    jPanel3.setBounds(new Rectangle(241, 38, 186, 96));
    jPanel3.setLayout(null);
    jLabel6.setText("Maximum Breadth");
    jLabel6.setBounds(new Rectangle(4, 11, 126, 18));
    jLabel7.setText("(Zero if not limited)");
    jLabel7.setBounds(new Rectangle(5, 27, 135, 18));
    jTextFieldMaxBreadth.setText("0");
    jTextFieldMaxBreadth.setBounds(new Rectangle(132, 11, 49, 24));
    jTextFieldMaxBreadth.setInputVerifier(new NumericInputVerifier());
    jLabel8.setText("Row Spacing");
    jLabel8.setBounds(new Rectangle(4, 50, 110, 18));
    jLabel9.setText("between Children");
    jLabel9.setBounds(new Rectangle(5, 68, 124, 18));
    jTextFieldRowSpacing.setText("25");
    jTextFieldRowSpacing.setBounds(new Rectangle(132, 50, 48, 24));
    jTextFieldRowSpacing.setInputVerifier(new NumericInputVerifier());
    jLabel10.setText("Parent to Children Alignment");
    jLabel10.setBounds(new Rectangle(241, 141, 203, 18));
    jPanel4.setBorder(BorderFactory.createLineBorder(Color.black));
    jPanel4.setBounds(new Rectangle(241, 159, 186, 156));
    jPanel4.setLayout(null);
    jLabel11.setText("Alignment");
    jLabel11.setBounds(new Rectangle(6, 7, 78, 18));
    jRadioButtonCenterSubtrees.setText("Center Subtrees");
    jRadioButtonCenterSubtrees.setBounds(new Rectangle(36, 21, 145, 27));
    jRadioButtonCenterChildren.setSelected(true);
    jRadioButtonCenterChildren.setText("Center Children");
    jRadioButtonCenterChildren.setBounds(new Rectangle(36, 41, 143, 27));
    jRadioButtonStart.setText("Start");
    jRadioButtonStart.setBounds(new Rectangle(36, 63, 107, 27));
    jRadioButtonEnd.setText("End");
    jRadioButtonEnd.setBounds(new Rectangle(36, 84, 107, 27));
    jLabel12.setText("Indent");
    jLabel12.setBounds(new Rectangle(6, 109, 48, 18));
    jTextFieldIndent.setToolTipText("");
    jTextFieldIndent.setText("0");
    jTextFieldIndent.setInputVerifier(new NumericInputVerifier());
    jTextFieldIndent.setBounds(new Rectangle(35, 126, 57, 24));
    jLabel13.setText("Tree Construction Path");
    jLabel13.setBounds(new Rectangle(18, 216, 176, 18));
    jPanel5.setBorder(BorderFactory.createLineBorder(Color.black));
    jPanel5.setBounds(new Rectangle(18, 236, 183, 62));
    jPanel5.setLayout(null);
    jRadioButtonDestAreChild.setSelected(true);
    jRadioButtonDestAreChild.setText("Destinations are Children");
    jRadioButtonDestAreChild.setBounds(new Rectangle(4, 7, 176, 27));
    jRadioButtonSourceAreChild.setText("Sources are Children");
    jRadioButtonSourceAreChild.setBounds(new Rectangle(4, 29, 178, 27));
    jLabel14.setText("Forest Arrangement");
    jLabel14.setBounds(new Rectangle(17, 304, 155, 18));
    jPanel6.setBorder(BorderFactory.createLineBorder(Color.black));
    jPanel6.setBounds(new Rectangle(17, 324, 183, 207));
    jPanel6.setLayout(null);
    jLabel15.setText("Arrangement");
    jLabel15.setBounds(new Rectangle(6, 9, 94, 18));
    jRadioButtonVertical.setSelected(true);
    jRadioButtonVertical.setText("Vertical");
    jRadioButtonVertical.setBounds(new Rectangle(19, 27, 107, 27));
    jRadioButtonHorizontal.setText("Horizontal");
    jRadioButtonHorizontal.setBounds(new Rectangle(19, 48, 107, 27));
    jRadioButtonFixedRoots.setText("Fixed Roots");
    jRadioButtonFixedRoots.setBounds(new Rectangle(19, 70, 107, 27));
    jLabel16.setText("Origin");
    jLabel16.setBounds(new Rectangle(6, 97, 48, 18));
    jLabel17.setText("X");
    jLabel17.setBounds(new Rectangle(31, 116, 22, 18));
    jTextFieldX.setBackground(Color.white);
    jTextFieldX.setText("20");
    jTextFieldX.setBounds(new Rectangle(49, 113, 42, 24));
    jTextFieldX.setInputVerifier(new NumericInputVerifier());
    jLabel18.setText("Y");
    jLabel18.setBounds(new Rectangle(93, 116, 24, 18));
    jTextFieldY.setText("20");
    jTextFieldY.setBounds(new Rectangle(106, 113, 28, 24));
    jTextFieldY.setInputVerifier(new NumericInputVerifier());
    jLabel19.setText("Spacing");
    jLabel19.setBounds(new Rectangle(6, 147, 48, 18));
    jLabel20.setText("W");
    jLabel20.setBounds(new Rectangle(31, 168, 24, 18));
    jTextFieldW.setText("50");
    jTextFieldW.setBounds(new Rectangle(49, 165, 28, 24));
    jTextFieldW.setInputVerifier(new NumericInputVerifier());
    jLabel21.setText("H");
    jLabel21.setBounds(new Rectangle(93, 167, 21, 18));
    jTextFieldH.setText("50");
    jTextFieldH.setBounds(new Rectangle(106, 165, 33, 24));
    jTextFieldH.setInputVerifier(new NumericInputVerifier());
    jLabel22.setText("Ordering of Children");
    jLabel22.setBounds(new Rectangle(241, 323, 130, 18));
    jPanel7.setBorder(BorderFactory.createLineBorder(Color.black));
    jPanel7.setBounds(new Rectangle(241, 343, 186, 95));
    jPanel7.setLayout(null);
    jRadioButtonForwardsIteration.setSelected(true);
    jRadioButtonForwardsIteration.setText("Forwards Iteration");
    jRadioButtonForwardsIteration.setBounds(new Rectangle(5, 3, 149, 27));
    jRadioButtonBackwardsIteration.setText("Backwards Iteration");
    jRadioButtonBackwardsIteration.setBounds(new Rectangle(5, 23, 159, 27));
    jRadioButtonAscendingTextSort.setText("Ascending Text Sort");
    jRadioButtonAscendingTextSort.setBounds(new Rectangle(5, 62, 167, 27));
    jRadioButtonDescendingTextSort.setText("Descending Text Sort");
    jRadioButtonDescendingTextSort.setBounds(new Rectangle(5, 42, 170, 27));
    jLabel23.setText("Tree Style");
    jLabel23.setBounds(new Rectangle(18, 539, 110, 18));
    jPanel8.setBorder(BorderFactory.createLineBorder(Color.black));
    jPanel8.setBounds(new Rectangle(16, 559, 416, 136));
    jPanel8.setLayout(null);
    jRadioButtonAlternateLeft.setText("Left");
    jRadioButtonAlternateLeft.setBounds(new Rectangle(300, 51, 47, 27));
    jRadioButtonAlternateDown.setSelected(false);
    jRadioButtonAlternateDown.setText("Down");
    jRadioButtonAlternateDown.setBounds(new Rectangle(230, 51, 57, 27));
    jRadioButtonAlternateRight.setSelected(true);
    jRadioButtonAlternateRight.setText("Right");
    jRadioButtonAlternateRight.setBounds(new Rectangle(300, 31, 55, 27));
    jRadioButtonAlternateUp.setText("Up");
    jRadioButtonAlternateUp.setBounds(new Rectangle(230, 31, 41, 27));
    jLabel24.setText("Alternate Direction");
    jLabel24.setBounds(new Rectangle(214, 13, 143, 18));
    jLabel25.setText("Alternate Breadth Limit");
    jLabel25.setBounds(new Rectangle(212, 79, 157, 18));
    jLabel26.setText("Style");
    jLabel26.setBounds(new Rectangle(7, 8, 48, 18));
    jRadioButtonStyleLayered.setSelected(true);
    jRadioButtonStyleLayered.setText("Layered");
    jRadioButtonStyleLayered.setBounds(new Rectangle(23, 24, 107, 27));
    jTextFieldAlternateBreadth.setText("0");
    jTextFieldAlternateBreadth.setBounds(new Rectangle(228, 100, 38, 24));
    jTextFieldAlternateBreadth.setInputVerifier(new NumericInputVerifier());
    jRadioButtonStyleAlternating.setText("Alternating");
    jRadioButtonStyleAlternating.setBounds(new Rectangle(23, 43, 107, 27));
    jRadioButtonStyleLastParents.setText("Last Parents");
    jRadioButtonStyleLastParents.setBounds(new Rectangle(24, 64, 107, 27));
    jLabel27.setText("Port Connection Spots");
    jLabel27.setBounds(new Rectangle(241, 446, 178, 18));
    jPanel9.setBorder(BorderFactory.createLineBorder(Color.black));
    jPanel9.setBounds(new Rectangle(241, 464, 186, 68));
    jPanel9.setLayout(null);
    jCheckBoxParentPortSpot.setText("Sets Parent Port Spot");
    jCheckBoxParentPortSpot.setBounds(new Rectangle(1, 4, 164, 27));
    jCheckBoxChildPortSpot.setText("Set Child Port Spot");
    jCheckBoxChildPortSpot.setBounds(new Rectangle(1, 28, 178, 27));
    jCheckBoxBlockCompaction.setSelected(true);
    jCheckBoxBlockCompaction.setText("Block Compaction");
    jCheckBoxBlockCompaction.setBounds(new Rectangle(15, 62, 154, 27));
    CancelButton.addActionListener(new TreeDialog_CancelButton_actionAdapter(this));
    jPanel2.add(jLabel3, null);
    jPanel2.add(jTextFieldNodeSpacing, null);
    jPanel2.add(jTextFieldLayerSpacing, null);
    jPanel2.add(jLabel4, null);
    jPanel2.add(jCheckBoxBlockCompaction, null);
    jPanel1.add(jRadioButtonUp, null);
    jPanel1.add(jRadioButtonLeft, null);
    jPanel1.add(jRadioButtonRight, null);
    jPanel1.add(jRadioButtonDown, null);
    panel1.add(jLabel5, null);
    panel1.add(jPanel3, null);
    jPanel3.add(jLabel6, null);
    jPanel3.add(jLabel7, null);
    jPanel3.add(jTextFieldMaxBreadth, null);
    jPanel3.add(jLabel8, null);
    jPanel3.add(jLabel9, null);
    jPanel3.add(jTextFieldRowSpacing, null);
    jPanel7.add(jRadioButtonForwardsIteration, null);
    jPanel7.add(jRadioButtonBackwardsIteration, null);
    jPanel7.add(jRadioButtonDescendingTextSort, null);
    jPanel7.add(jRadioButtonAscendingTextSort, null);
    panel1.add(jLabel14, null);
    panel1.add(jPanel6, null);
    jPanel6.add(jLabel15, null);
    jPanel6.add(jRadioButtonVertical, null);
    jPanel6.add(jRadioButtonHorizontal, null);
    jPanel6.add(jRadioButtonFixedRoots, null);
    jPanel6.add(jLabel16, null);
    jPanel6.add(jLabel17, null);
    jPanel6.add(jTextFieldX, null);
    jPanel6.add(jTextFieldY, null);
    jPanel6.add(jLabel19, null);
    jPanel6.add(jLabel20, null);
    jPanel6.add(jTextFieldW, null);
    jPanel6.add(jLabel18, null);
    jPanel6.add(jLabel21, null);
    jPanel6.add(jTextFieldH, null);
    panel1.setLayout(null);
    panel1.setMinimumSize(new Dimension(450, 740));
    panel1.setPreferredSize(new Dimension(450, 740));
    CancelButton.setBounds(new Rectangle(115, 703, 83, 27));
    CancelButton.setText("Cancel");
    OKButton.setText("");
    OKButton.setBounds(new Rectangle(17, 703, 83, 27));
    OKButton.setText("OK");
    OKButton.addActionListener(new TreeDialog_OKButton_actionAdapter(this));
    jPanel1.setBorder(BorderFactory.createLineBorder(Color.black));
    jPanel1.setBounds(new Rectangle(18, 39, 183, 54));
    jPanel1.setLayout(null);
    jLabel1.setText("Tree Growth Direction (Angle)");
    jLabel1.setBounds(new Rectangle(19, 19, 186, 18));
    jRadioButtonUp.setText("Up");
    jRadioButtonUp.setBounds(new Rectangle(7, 3, 77, 27));
    jRadioButtonDown.setSelected(true);
    jRadioButtonDown.setText("Down");
    jRadioButtonDown.setBounds(new Rectangle(7, 25, 82, 27));
    jRadioButtonLeft.setText("Left");
    jRadioButtonLeft.setBounds(new Rectangle(87, 3, 64, 27));
    jRadioButtonRight.setText("Right");
    jRadioButtonRight.setBounds(new Rectangle(86, 25, 68, 27));
    jLabel2.setText("Spacing");
    jLabel2.setBounds(new Rectangle(19, 97, 95, 18));
    jPanel2.setBorder(BorderFactory.createLineBorder(Color.black));
    jPanel2.setBounds(new Rectangle(19, 116, 183, 95));
    jPanel2.setLayout(null);
    jLabel3.setText("Between Nodes");
    jLabel3.setBounds(new Rectangle(10, 11, 106, 18));
    jLabel4.setText("Between Layers");
    jLabel4.setBounds(new Rectangle(10, 39, 117, 18));
    jTextFieldNodeSpacing.setText("20");
    jTextFieldNodeSpacing.setBounds(new Rectangle(118, 9, 48, 24));
    jTextFieldNodeSpacing.setInputVerifier(new NumericInputVerifier());
    jTextFieldNodeSpacing.setInputVerifier(new NumericInputVerifier());
    jTextFieldLayerSpacing.setText("50");
    jTextFieldLayerSpacing.setBounds(new Rectangle(118, 36, 49, 24));
    jTextFieldLayerSpacing.setInputVerifier(new NumericInputVerifier());
    buttonGroupDirection.add(jRadioButtonUp);
    buttonGroupDirection.add(jRadioButtonDown);
    buttonGroupDirection.add(jRadioButtonLeft);
    buttonGroupDirection.add(jRadioButtonRight);
    jPanel4.add(jLabel11, null);
    jPanel4.add(jRadioButtonCenterSubtrees, null);
    jPanel4.add(jRadioButtonCenterChildren, null);
    jPanel4.add(jRadioButtonEnd, null);
    jPanel4.add(jRadioButtonStart, null);
    jPanel4.add(jLabel12, null);
    jPanel4.add(jTextFieldIndent, null);
    panel1.add(jLabel2, null);
    panel1.add(jPanel2, null);
    panel1.add(jPanel9, null);
    buttonGroupAlignment.add(jRadioButtonCenterSubtrees);
    buttonGroupAlignment.add(jRadioButtonCenterChildren);
    buttonGroupAlignment.add(jRadioButtonStart);
    buttonGroupAlignment.add(jRadioButtonEnd);
    buttonGroupTreeConstructionPath.add(jRadioButtonDestAreChild);
    buttonGroupTreeConstructionPath.add(jRadioButtonSourceAreChild);
    jPanel5.add(jRadioButtonDestAreChild, null);
    jPanel5.add(jRadioButtonSourceAreChild, null);
    panel1.add(jLabel13, null);
    panel1.add(jPanel5, null);
    panel1.add(jLabel1, null);
    panel1.add(jPanel1, null);
    buttonGroupArrangement.add(jRadioButtonVertical);
    buttonGroupArrangement.add(jRadioButtonHorizontal);
    buttonGroupArrangement.add(jRadioButtonFixedRoots);
    jPanel8.add(jLabel26, null);
    jPanel8.add(jRadioButtonStyleLayered, null);
    jPanel8.add(jRadioButtonStyleAlternating, null);
    jPanel8.add(jRadioButtonStyleLastParents, null);
    jPanel8.add(jLabel24, null);
    jPanel8.add(jRadioButtonAlternateUp, null);
    jPanel8.add(jRadioButtonAlternateDown, null);
    jPanel8.add(jRadioButtonAlternateRight, null);
    jPanel8.add(jRadioButtonAlternateLeft, null);
    jPanel8.add(jLabel25, null);
    jPanel8.add(jTextFieldAlternateBreadth, null);
    panel1.add(OKButton, null);
    panel1.add(CancelButton, null);
    panel1.add(jLabel23, null);
    panel1.add(jPanel8, null);
    panel1.add(jPanel7, null);
    panel1.add(jLabel10, null);
    panel1.add(jLabel27, null);
    panel1.add(jLabel22, null);
    panel1.add(jPanel4, null);
    this.getContentPane().add(panel1, BorderLayout.CENTER);
    OKButton.getRootPane().setDefaultButton(OKButton);
    buttonGroupAlternateDirection.add(jRadioButtonAlternateUp);
    buttonGroupAlternateDirection.add(jRadioButtonAlternateDown);
    buttonGroupAlternateDirection.add(jRadioButtonAlternateRight);
    buttonGroupAlternateDirection.add(jRadioButtonAlternateLeft);
    buttonGroupStyle.add(jRadioButtonStyleLayered);
    buttonGroupStyle.add(jRadioButtonStyleAlternating);
    buttonGroupStyle.add(jRadioButtonStyleLastParents);
    buttonGroupChildOrder.add(jRadioButtonForwardsIteration);
    buttonGroupChildOrder.add(jRadioButtonBackwardsIteration);
    buttonGroupChildOrder.add(jRadioButtonDescendingTextSort);
    buttonGroupChildOrder.add(jRadioButtonAscendingTextSort);
    jPanel9.add(jCheckBoxParentPortSpot, null);
    jPanel9.add(jCheckBoxChildPortSpot, null);
  }

  void OKButton_actionPerformed(ActionEvent e) {
    OnOK();
  }

  void UpdateControl() {
    // Layout direction
    if (myView != null) {
      myAutoLayout = new JGoTreeAutoLayout(myView.getDocument());
      if (jRadioButtonDown.isSelected())
        myAutoLayout.setAngle(90);
      if (jRadioButtonUp.isSelected())
        myAutoLayout.setAngle(270);
      if (jRadioButtonLeft.isSelected())
        myAutoLayout.setAngle(180);
      if (jRadioButtonRight.isSelected())
        myAutoLayout.setAngle(0);
      // Spacing
      myAutoLayout.setNodeSpacing(Integer.parseInt(jTextFieldNodeSpacing.getText()));
      myAutoLayout.setLayerSpacing(Integer.parseInt(jTextFieldLayerSpacing.getText()));
      if (this.jCheckBoxBlockCompaction.isSelected())
        myAutoLayout.setCompaction(JGoTreeNetworkNode.CompactionBlock);
      else
        myAutoLayout.setCompaction(JGoTreeNetworkNode.CompactionNone);
      // Maximum Tree Size
      myAutoLayout.setBreadthLimit(Integer.parseInt(jTextFieldMaxBreadth.getText()));
      myAutoLayout.setRowSpacing(Integer.parseInt(jTextFieldRowSpacing.getText()));
      // Parent to Children Alignment
      if (this.jRadioButtonCenterChildren.isSelected())
        myAutoLayout.setAlignment(JGoTreeNetworkNode.AlignmentCenterChildren);
      if (this.jRadioButtonCenterSubtrees.isSelected())
        myAutoLayout.setAlignment(JGoTreeNetworkNode.AlignmentCenterSubtrees);
      if (this.jRadioButtonStart.isSelected())
        myAutoLayout.setAlignment(JGoTreeNetworkNode.AlignmentStart);
      if (this.jRadioButtonEnd.isSelected())
        myAutoLayout.setAlignment(JGoTreeNetworkNode.AlignmentEnd);
      myAutoLayout.setNodeIndent(Integer.parseInt(jTextFieldIndent.getText()));
      // Tree Construction Path
      if (this.jRadioButtonDestAreChild.isSelected())
        myAutoLayout.setPath(JGoTreeAutoLayout.PathDestination);
      if (this.jRadioButtonSourceAreChild.isSelected())
        myAutoLayout.setPath(JGoTreeAutoLayout.PathSource);
      myAutoLayout.setNodeIndent(Integer.parseInt(jTextFieldIndent.getText()));
      // Forest Arrangement
      if (this.jRadioButtonFixedRoots.isSelected())
        myAutoLayout.setArrangement(myAutoLayout.ArrangementFixedRoots);
      if (this.jRadioButtonHorizontal.isSelected())
        myAutoLayout.setArrangement(myAutoLayout.ArrangementHorizontal);
      if (this.jRadioButtonVertical.isSelected())
        myAutoLayout.setArrangement(myAutoLayout.ArrangementVertical);
      myAutoLayout.setArrangementOrigin(new Point(Integer.parseInt(jTextFieldX.getText()),
          Integer.parseInt(this.jTextFieldY.getText())));
      myAutoLayout.setArrangementSpacing(new Dimension(Integer.parseInt(this.jTextFieldW.getText()),
          Integer.parseInt(this.jTextFieldH.getText())));
      // Ordering of Children
      if (this.jRadioButtonForwardsIteration.isSelected())
        myAutoLayout.setSorting(JGoTreeNetworkNode.SortingForwards);
      if (this.jRadioButtonBackwardsIteration.isSelected())
        myAutoLayout.setSorting(JGoTreeNetworkNode.SortingReverse);
      if (this.jRadioButtonAscendingTextSort.isSelected())
        myAutoLayout.setSorting(JGoTreeNetworkNode.SortingAscending);
      if (this.jRadioButtonDescendingTextSort.isSelected())
        myAutoLayout.setSorting(JGoTreeNetworkNode.SortingDescending);
      // Port Connection Spots
      myAutoLayout.setSetsPortSpot(this.jCheckBoxParentPortSpot.isSelected());
      myAutoLayout.setSetsChildPortSpot(this.jCheckBoxChildPortSpot.isSelected());
      // Set AlternateDefaults properties
      myAutoLayout.getAlternateDefaults().CopyInheritedPropertiesFrom(myAutoLayout.getRootDefaults());
      // Tree Style
      if (this.jRadioButtonStyleAlternating.isSelected())
        myAutoLayout.setStyle(myAutoLayout.StyleAlternating);
      if (this.jRadioButtonStyleLastParents.isSelected())
        myAutoLayout.setStyle(myAutoLayout.StyleLastParents);
      if (this.jRadioButtonStyleLayered.isSelected())
        myAutoLayout.setStyle(myAutoLayout.StyleLayered);
      if (this.jRadioButtonAlternateDown.isSelected())
        myAutoLayout.getAlternateDefaults().setAngle(90);
      if (this.jRadioButtonAlternateLeft.isSelected())
        myAutoLayout.getAlternateDefaults().setAngle(180);
      if (this.jRadioButtonAlternateRight.isSelected())
        myAutoLayout.getAlternateDefaults().setAngle(0);
      if (this.jRadioButtonAlternateUp.isSelected())
        myAutoLayout.getAlternateDefaults().setAngle(270);
      myAutoLayout.getAlternateDefaults().setBreadthLimit(Integer.parseInt(this.jTextFieldAlternateBreadth.getText()));
    }
  }

public DemoView getView() {
  return myView;
}

private DemoView myView;
private JGoTreeAutoLayout myAutoLayout;
  JPanel jPanel1 = new JPanel();
  JLabel jLabel1 = new JLabel();
  ButtonGroup buttonGroupDirection = new ButtonGroup();
  JRadioButton jRadioButtonUp = new JRadioButton();
  JRadioButton jRadioButtonDown = new JRadioButton();
  JRadioButton jRadioButtonLeft = new JRadioButton();
  JRadioButton jRadioButtonRight = new JRadioButton();
  JLabel jLabel2 = new JLabel();
  JPanel jPanel2 = new JPanel();
  JLabel jLabel3 = new JLabel();
  JLabel jLabel4 = new JLabel();
  JTextField jTextFieldNodeSpacing = new JTextField();
  JTextField jTextFieldLayerSpacing = new JTextField();
  JLabel jLabel5 = new JLabel();
  JPanel jPanel3 = new JPanel();
  JLabel jLabel6 = new JLabel();
  JLabel jLabel7 = new JLabel();
  JTextField jTextFieldMaxBreadth = new JTextField();
  JLabel jLabel8 = new JLabel();
  JLabel jLabel9 = new JLabel();
  JTextField jTextFieldRowSpacing = new JTextField();
  JLabel jLabel10 = new JLabel();
  JPanel jPanel4 = new JPanel();
  JLabel jLabel11 = new JLabel();
  ButtonGroup buttonGroupAlignment = new ButtonGroup();
  JRadioButton jRadioButtonCenterSubtrees = new JRadioButton();
  JRadioButton jRadioButtonCenterChildren = new JRadioButton();
  JRadioButton jRadioButtonStart = new JRadioButton();
  JRadioButton jRadioButtonEnd = new JRadioButton();
  JLabel jLabel12 = new JLabel();
  JTextField jTextFieldIndent = new JTextField();
  JLabel jLabel13 = new JLabel();
  JPanel jPanel5 = new JPanel();
  JRadioButton jRadioButtonDestAreChild = new JRadioButton();
  ButtonGroup buttonGroupTreeConstructionPath = new ButtonGroup();
  JRadioButton jRadioButtonSourceAreChild = new JRadioButton();
  JLabel jLabel14 = new JLabel();
  JPanel jPanel6 = new JPanel();
  JLabel jLabel15 = new JLabel();
  JRadioButton jRadioButtonVertical = new JRadioButton();
  JRadioButton jRadioButtonHorizontal = new JRadioButton();
  JRadioButton jRadioButtonFixedRoots = new JRadioButton();
  ButtonGroup buttonGroupArrangement = new ButtonGroup();
  JLabel jLabel16 = new JLabel();
  JLabel jLabel17 = new JLabel();
  JTextField jTextFieldX = new JTextField();
  JLabel jLabel18 = new JLabel();
  JTextField jTextFieldY = new JTextField();
  JLabel jLabel19 = new JLabel();
  JLabel jLabel20 = new JLabel();
  JTextField jTextFieldW = new JTextField();
  JLabel jLabel21 = new JLabel();
  JTextField jTextFieldH = new JTextField();
  JLabel jLabel22 = new JLabel();
  JPanel jPanel7 = new JPanel();
  JRadioButton jRadioButtonForwardsIteration = new JRadioButton();
  JRadioButton jRadioButtonBackwardsIteration = new JRadioButton();
  JRadioButton jRadioButtonAscendingTextSort = new JRadioButton();
  JRadioButton jRadioButtonDescendingTextSort = new JRadioButton();
  JLabel jLabel23 = new JLabel();
  JPanel jPanel8 = new JPanel();
  JRadioButton jRadioButtonAlternateLeft = new JRadioButton();
  JRadioButton jRadioButtonAlternateDown = new JRadioButton();
  JRadioButton jRadioButtonAlternateRight = new JRadioButton();
  JRadioButton jRadioButtonAlternateUp = new JRadioButton();
  JLabel jLabel24 = new JLabel();
  JLabel jLabel25 = new JLabel();
  JLabel jLabel26 = new JLabel();
  JRadioButton jRadioButtonStyleLayered = new JRadioButton();
  JTextField jTextFieldAlternateBreadth = new JTextField();
  JRadioButton jRadioButtonStyleAlternating = new JRadioButton();
  JRadioButton jRadioButtonStyleLastParents = new JRadioButton();
  JLabel jLabel27 = new JLabel();
  JPanel jPanel9 = new JPanel();
  ButtonGroup buttonGroupAlternateDirection = new ButtonGroup();
  ButtonGroup buttonGroupStyle = new ButtonGroup();
  ButtonGroup buttonGroupChildOrder = new ButtonGroup();
  ButtonGroup buttonGroupConnectionSpot = new ButtonGroup();
  JCheckBox jCheckBoxParentPortSpot = new JCheckBox();
  JCheckBox jCheckBoxChildPortSpot = new JCheckBox();
  JCheckBox jCheckBoxBlockCompaction = new JCheckBox();

  void CancelButton_actionPerformed(ActionEvent e) {
    OnCancel();
  }

  public void setVisible(boolean b)
  {
    if (b) {
      Rectangle bounds = getParent().getBounds();
      setLocation(bounds.x + 100,
                  bounds.y + 60);
    }
    super.setVisible(b);
  }

  void OnOK()
  {
    try {
      UpdateControl();
      this.dispose();             // Free system resources
      if (myAutoLayout != null) {
        myView.setDefaultCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
        myAutoLayout.performLayout();
        myView.zoomToFit();
        myView.setDefaultCursor(null);
      }
    } catch (Exception e) {
      JOptionPane.showMessageDialog(this, e.toString());
      e.printStackTrace();
    }
  }

  void OnCancel()
  {
    try {
      this.dispose();             // Free system resources
    } catch (Exception e) {
    }
  }

}

class TreeDialog_OKButton_actionAdapter implements java.awt.event.ActionListener {
  TreeDialog adaptee;

  TreeDialog_OKButton_actionAdapter(TreeDialog adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.OKButton_actionPerformed(e);
  }
}

class NumericInputVerifier
    extends InputVerifier {
  public boolean verify(JComponent comp) {
    boolean returnValue = true;
    JTextField textField = (JTextField) comp;
    String content = textField.getText();
    if (content.length() != 0) {
      try {
        Integer.parseInt(textField.getText());
      }
      catch (NumberFormatException e) {
        returnValue = false;
      }
    }
    return returnValue;
  }

  public boolean shouldYieldFocus(JComponent input) {
    boolean valid = super.shouldYieldFocus(input);
    if (!valid) {
      input.getToolkit().beep();
    }
    return valid;
  }
}

class TreeDialog_CancelButton_actionAdapter implements java.awt.event.ActionListener {
  TreeDialog adaptee;

  TreeDialog_CancelButton_actionAdapter(TreeDialog adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.CancelButton_actionPerformed(e);
  }
}
