/*
 *  Copyright (c) Northwoods Software Corporation, 1998-2008. All Rights
 *  Reserved.
 *
 *  Restricted Rights: Use, duplication, or disclosure by the U.S.
 *  Government is subject to restrictions as set forth in subparagraph
 *  (c) (1) (ii) of DFARS 252.227-7013, or in FAR 52.227-19, or in FAR
 *  52.227-14 Alt. III, as applicable.
 *
 */

package com.nwoods.jgo.examples.sampleapp;

import java.awt.*;
import java.awt.event.*;
import java.io.FileOutputStream;
import java.io.FileInputStream;
import javax.swing.*;
import com.nwoods.jgo.*;
import com.nwoods.jgo.layout.*;
import com.nwoods.jgo.svg.*;

public class Frame1 extends JFrame {
  JPanel contentPane;
  BorderLayout borderLayout1 = new BorderLayout();
  JSplitPane jSplitPane1 = new JSplitPane();
  JSplitPane jSplitPane2 = new JSplitPane();
  JGoOverview jGoOverview1 = new JGoOverview();
  JGoPalette jGoPalette1 = new JGoPalette();
  JGoView jGoView1 = new JGoView();
  JMenuBar jMenuBar1 = new JMenuBar();
  JMenu jMenu1 = new JMenu();
  JMenu jMenu2 = new JMenu();
  JMenuItem CopyItem = new JMenuItem();
  JMenuItem CutItem = new JMenuItem();
  JMenuItem PasteItem = new JMenuItem();
  JMenuItem UndoItem = new JMenuItem();
  JMenuItem RedoItem = new JMenuItem();
  JMenuItem LayoutItem = new JMenuItem();
  JMenuItem SaveItem = new JMenuItem();
  JMenuItem OpenItem = new JMenuItem();

  //Construct the frame
  public Frame1() {
    enableEvents(AWTEvent.WINDOW_EVENT_MASK);
    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }
  //Component initialization
  private void jbInit() throws Exception  {
    JGoUndoManager undoManager = new JGoUndoManager();
    jGoView1.getDocument().setUndoManager(undoManager);
    contentPane = (JPanel) this.getContentPane();
    contentPane.setLayout(borderLayout1);
    this.setJMenuBar(jMenuBar1);
    this.setSize(new Dimension(635, 478));
    this.setTitle("Frame Title");
    jSplitPane2.setOrientation(JSplitPane.VERTICAL_SPLIT);
    jGoOverview1.setObserved(jGoView1);
    jGoView1.addDocumentListener(new Frame1_jGoView1_documentAdapter(this));
    jGoView1.addViewListener(new Frame1_jGoView1_viewAdapter(this));
    jGoView1.addKeyListener(new Frame1_jGoView1_keyAdapter(this));
    jMenu1.setText("File");
    jMenu2.setText("Edit");
    CopyItem.setText("Copy");
    CopyItem.addActionListener(new Frame1_CopyItem_actionAdapter(this));
    CutItem.setText("Cut");
    CutItem.addActionListener(new Frame1_CutItem_actionAdapter(this));
    PasteItem.setText("Paste");
    PasteItem.addActionListener(new Frame1_PasteItem_actionAdapter(this));
    UndoItem.setText("Undo");
    UndoItem.addActionListener(new Frame1_UndoItem_actionAdapter(this));
    RedoItem.setText("Redo");
    RedoItem.addActionListener(new Frame1_RedoItem_actionAdapter(this));
    LayoutItem.setText("Layout");
    LayoutItem.addActionListener(new Frame1_LayoutItem_actionAdapter(this));
    SaveItem.setText("Save...");
    SaveItem.addActionListener(new Frame1_SaveItem_actionAdapter(this));
    OpenItem.setText("Open...");
    OpenItem.addActionListener(new Frame1_OpenItem_actionAdapter(this));
    contentPane.add(jSplitPane1, BorderLayout.CENTER);
    jSplitPane1.add(jSplitPane2, JSplitPane.LEFT);
    jSplitPane2.add(jGoOverview1, JSplitPane.TOP);
    jSplitPane2.add(jGoPalette1, JSplitPane.BOTTOM);
    jSplitPane1.add(jGoView1, JSplitPane.RIGHT);
    jMenuBar1.add(jMenu1);
    jMenuBar1.add(jMenu2);
    jMenu2.add(CopyItem);
    jMenu2.add(CutItem);
    jMenu2.add(PasteItem);
    jMenu2.addSeparator();
    jMenu2.add(UndoItem);
    jMenu2.add(RedoItem);
    jMenu2.addSeparator();
    jMenu2.add(LayoutItem);
    jMenu1.add(SaveItem);
    jMenu1.add(OpenItem);
    jSplitPane1.setDividerLocation(100);

    SampleNode node1 = new SampleNode("Blue Node");
    node1.setBrush(new JGoBrush(Color.blue));
    node1.setIntVal(1);
    SampleNode node2 = new SampleNode("Red Node");
    node2.setBrush(new JGoBrush(Color.red));
    node2.setIntVal(2);
    SampleNode node3 = new SampleNode("Green Node");
    node3.setBrush(new JGoBrush(Color.green));
    node3.setIntVal(3);
    jGoPalette1.getDocument().addObjectAtTail(node1);
    jGoPalette1.getDocument().addObjectAtTail(node2);
    jGoPalette1.getDocument().addObjectAtTail(node3);
  }
  //Overridden so we can exit when window is closed
  protected void processWindowEvent(WindowEvent e) {
    super.processWindowEvent(e);
    if (e.getID() == WindowEvent.WINDOW_CLOSING) {
      System.exit(0);
    }
  }

  void jGoView1_documentChanged(JGoDocumentEvent e) {
    switch (e.getHint()) {
      case JGoDocumentEvent.INSERTED:
        if (e.getJGoObject()instanceof JGoLink) {
          JGoLink link = (JGoLink) e.getJGoObject();
          link.setArrowHeads(false, true);
        }
        break;
    }
  }

  void jGoView1_viewChanged(JGoViewEvent e) {
    switch (e.getHint()) {
      case JGoViewEvent.DOUBLE_CLICKED:
        JGoObject obj = (JGoObject)e.getJGoObject().getTopLevelObject();
        if (obj instanceof SampleNode) {
          SampleNode node = (SampleNode)obj;
          JOptionPane.showMessageDialog(null, node.getText() + " " + Integer.toString(node.getIntVal()));
        }
        else {
          JOptionPane.showMessageDialog(null, e.getJGoObject().getTopLevelObject().getClass().getName());
        }
        break;
      case JGoViewEvent.BACKGROUND_DOUBLE_CLICKED:
        JOptionPane.showMessageDialog(null, "Double-clicked on background");
        break;
    }
  }

  void jGoView1_keyPressed(KeyEvent e) {
    switch (e.getKeyCode()) {
      case KeyEvent.VK_DELETE:
        jGoView1.deleteSelection();
        break;
    }
  }

  void CopyItem_actionPerformed(ActionEvent e) {
    jGoView1.copy();
  }

  void CutItem_actionPerformed(ActionEvent e) {
    jGoView1.cut();
  }

  void PasteItem_actionPerformed(ActionEvent e) {
    jGoView1.paste();
  }

  void UndoItem_actionPerformed(ActionEvent e) {
    jGoView1.getDocument().undo();
  }

  void RedoItem_actionPerformed(ActionEvent e) {
    jGoView1.getDocument().redo();
  }

  void LayoutItem_actionPerformed(ActionEvent e) {
    JGoLayeredDigraphAutoLayout layout = new JGoLayeredDigraphAutoLayout(jGoView1.getDocument());
    layout.setDirectionOption(JGoLayeredDigraphAutoLayout.LD_DIRECTION_RIGHT);
    layout.setLayerSpacing(10);
    layout.setColumnSpacing(10);
    layout.performLayout();
  }

  void SaveItem_actionPerformed(ActionEvent e) {
    JFileChooser chooser = new JFileChooser();
    int returnVal = chooser.showSaveDialog(null);
    if (returnVal == JFileChooser.APPROVE_OPTION) {
      try {
        String loc = chooser.getSelectedFile().getAbsolutePath();
        FileOutputStream fstream = new FileOutputStream(loc);
        DefaultDocument svgDomDoc = new DefaultDocument();
        svgDomDoc.SVGWriteDoc(fstream, jGoView1.getDocument());
      }
      catch (Exception ex) {
        ex.printStackTrace();
      }
    }
  }

  void OpenItem_actionPerformed(ActionEvent e) {
    JFileChooser chooser = new JFileChooser();
    int returnVal = chooser.showOpenDialog(this);
    if (returnVal == JFileChooser.APPROVE_OPTION) {
      try {
        String loc = chooser.getSelectedFile().getAbsolutePath();
        FileInputStream fstream = new FileInputStream(loc);
        DefaultDocument svgDomDoc = new DefaultDocument();
        svgDomDoc.SVGReadDoc(fstream, jGoView1.getDocument());
      }
      catch (Exception ex) {
        ex.printStackTrace();
      }
    }
  }
}

class Frame1_jGoView1_documentAdapter implements com.nwoods.jgo.JGoDocumentListener {
  Frame1 adaptee;

  Frame1_jGoView1_documentAdapter(Frame1 adaptee) {
    this.adaptee = adaptee;
  }
  public void documentChanged(JGoDocumentEvent e) {
    adaptee.jGoView1_documentChanged(e);
  }
}

class Frame1_jGoView1_viewAdapter implements com.nwoods.jgo.JGoViewListener {
  Frame1 adaptee;

  Frame1_jGoView1_viewAdapter(Frame1 adaptee) {
    this.adaptee = adaptee;
  }
  public void viewChanged(JGoViewEvent e) {
    adaptee.jGoView1_viewChanged(e);
  }
}

class Frame1_jGoView1_keyAdapter extends java.awt.event.KeyAdapter {
  Frame1 adaptee;

  Frame1_jGoView1_keyAdapter(Frame1 adaptee) {
    this.adaptee = adaptee;
  }
  public void keyPressed(KeyEvent e) {
    adaptee.jGoView1_keyPressed(e);
  }
}

class Frame1_CopyItem_actionAdapter implements java.awt.event.ActionListener {
  Frame1 adaptee;

  Frame1_CopyItem_actionAdapter(Frame1 adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.CopyItem_actionPerformed(e);
  }
}

class Frame1_CutItem_actionAdapter implements java.awt.event.ActionListener {
  Frame1 adaptee;

  Frame1_CutItem_actionAdapter(Frame1 adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.CutItem_actionPerformed(e);
  }
}

class Frame1_PasteItem_actionAdapter implements java.awt.event.ActionListener {
  Frame1 adaptee;

  Frame1_PasteItem_actionAdapter(Frame1 adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.PasteItem_actionPerformed(e);
  }
}

class Frame1_UndoItem_actionAdapter implements java.awt.event.ActionListener {
  Frame1 adaptee;

  Frame1_UndoItem_actionAdapter(Frame1 adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.UndoItem_actionPerformed(e);
  }
}

class Frame1_RedoItem_actionAdapter implements java.awt.event.ActionListener {
  Frame1 adaptee;

  Frame1_RedoItem_actionAdapter(Frame1 adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.RedoItem_actionPerformed(e);
  }
}

class Frame1_LayoutItem_actionAdapter implements java.awt.event.ActionListener {
  Frame1 adaptee;

  Frame1_LayoutItem_actionAdapter(Frame1 adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.LayoutItem_actionPerformed(e);
  }
}

class Frame1_SaveItem_actionAdapter implements java.awt.event.ActionListener {
  Frame1 adaptee;

  Frame1_SaveItem_actionAdapter(Frame1 adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.SaveItem_actionPerformed(e);
  }
}

class Frame1_OpenItem_actionAdapter implements java.awt.event.ActionListener {
  Frame1 adaptee;

  Frame1_OpenItem_actionAdapter(Frame1 adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.OpenItem_actionPerformed(e);
  }
}