/*
 *  Copyright (c) Northwoods Software Corporation, 1998-2008. All Rights
 *  Reserved.
 *
 *  Restricted Rights: Use, duplication, or disclosure by the U.S.
 *  Government is subject to restrictions as set forth in subparagraph
 *  (c) (1) (ii) of DFARS 252.227-7013, or in FAR 52.227-19, or in FAR
 *  52.227-14 Alt. III, as applicable.
 *
 */

package com.nwoods.jgo.examples.sampleapp;

import com.nwoods.jgo.*;

public class SampleNode extends JGoBasicNode {

  public SampleNode() {
  }

  public SampleNode(String label) {
    super(label);
  }

  public int getIntVal() {
    return myInt;
  }

  public void setIntVal(int iVal) {
    int oldVal = myInt;
    if (oldVal != iVal) {
      myInt = iVal;
      // Signal state change to support undo/redo
      update(IntValChanged, oldVal, null);
    }
  }

  public JGoObject copyObject(JGoCopyEnvironment env) {
    SampleNode newobj = (SampleNode)super.copyObject(env);
    newobj.myInt = myInt;
    return newobj;
  }

  public void copyNewValueForRedo(JGoDocumentChangedEdit e)
  {
    // Copy the current state before doing the undo so it can
    // be reset in a future redo operation
    switch (e.getFlags()) {
      case IntValChanged:
        e.setNewValueInt(myInt);
        return;
      default:
        super.copyNewValueForRedo(e);
        return;
    }
  }

  public void changeValue(JGoDocumentChangedEdit e, boolean undo)
  {
    // Actually perform the undo or redo operation
    switch (e.getFlags()) {
      case IntValChanged:
        setIntVal(e.getValueInt(undo));
        return;
      default:
        super.changeValue(e, undo);
        return;
    }
  }

  public void SVGWriteObject(DomDoc svgDoc, DomElement jGoElementGroup)
  {
    // Add SampleNode element
    DomElement jGoSampleNode = svgDoc.createJGoClassElement("com.nwoods.jgo.examples.sampleapp.SampleNode", jGoElementGroup);
    jGoSampleNode.setAttribute("intval", Integer.toString(myInt));
    // Have superclass add to the JGoObject group
    super.SVGWriteObject(svgDoc, jGoElementGroup);
  }

  public DomNode SVGReadObject(DomDoc svgDoc, JGoDocument jGoDoc, DomElement svgElement, DomElement jGoChildElement)
  {
    if (jGoChildElement != null) {
      // This is a SampleNode element
      myInt = Integer.parseInt(jGoChildElement.getAttribute("intval"));
      super.SVGReadObject(svgDoc, jGoDoc, svgElement,
                          jGoChildElement.getNextSiblingJGoClassElement());
    }
    return svgElement.getNextSibling();
  }

  public static final int IntValChanged = JGoDocumentEvent.LAST + 10000;
  private int myInt;
}