package com.nwoods.jgo.examples.updatedemo;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.undo.*;
import java.util.*;
import com.nwoods.jgo.*;

public class UndoMgr extends JGoUndoManager {
  public UndoMgr() {}

  // override these UndoManager methods to trap updates

  public boolean addEdit(UndoableEdit undoable) {
    setLogPrefix("");
    logChanges(undoable, true);
    return super.addEdit(undoable);
  }

  public void endTransaction(String pname) {
    boolean outer = (getTransactionLevel() == 1);
    super.endTransaction(pname);
    if (outer) {
      UpdateDemo.AddLogMessage("  ended: " + pname);
    }
  }

  public void undo() {
    if (canUndo()) {
      setLogPrefix(" UNDO: ");
      logChanges(editToBeUndone(), false);
    }
    super.undo();
  }

  public void redo() {
    if (canRedo()) {
      setLogPrefix(" REDO: ");
      logChanges(editToBeRedone(), true);
    }
    super.redo();
  }

  // logging methods

  public String getLogPrefix() { return myLogPrefix; }
  public void setLogPrefix(String s) { myLogPrefix = s; }

  public void logChanges(UndoableEdit undoable, boolean forwards) {
    if (undoable instanceof JGoCompoundEdit) {
      JGoCompoundEdit compound = (JGoCompoundEdit)undoable;
      Vector edits = compound.getAllEdits();
      if (forwards) {
        for (int i = 0; i < edits.size(); i++) {
          JGoDocumentChangedEdit edit = (JGoDocumentChangedEdit)edits.get(i);
          logChange(edit);
        }
      } else {
        for (int i = edits.size()-1; i >= 0; i--) {
          JGoDocumentChangedEdit edit = (JGoDocumentChangedEdit)edits.get(i);
          logChange(edit);
        }
      }
    }
  }

  public void logChange(JGoDocumentChangedEdit edit) {
    if (edit.getHint() == JGoDocumentEvent.INSERTED) {
      UpdateDemo.AddLogMessage(getLogPrefix() + "inserted " + ID(edit.getObject()));
    } else if (edit.getHint() == JGoDocumentEvent.REMOVED) {
      UpdateDemo.AddLogMessage(getLogPrefix() + "removed " + ID(edit.getObject()));
    } else if (edit.getHint() == JGoDocumentEvent.CHANGED) {
      if (edit.getFlags() == JGoLink.ChangedFromPort) {
        UpdateDemo.AddLogMessage(getLogPrefix() + "changed link's From port from: " + ID(edit.getOldValue()) + "  to: " + ID(edit.getNewValue()));
      } else if (edit.getFlags() == JGoLink.ChangedToPort) {
        UpdateDemo.AddLogMessage(getLogPrefix() + "changed link's To port from: " + ID(edit.getOldValue()) + "  to: " + ID(edit.getNewValue()));
      } else if (edit.getFlags() == JGoObject.ChangedGeometry && edit.getObject() instanceof JGoNode) {
        UpdateDemo.AddLogMessage(getLogPrefix() + "changed BoundingRect from: " + RECT((Rectangle)edit.getOldValue()) + "  to: " + RECT(((JGoObject)edit.getObject()).getBoundingRect()));
      }
    }
  }

  public String ID(Object obj) {
    if (obj == null) {
      return "(null)";
    } else if (obj instanceof JGoPort) {
      JGoPort port = (JGoPort)obj;
      if (port.getParentNode() != port)
        return ID(port.getParentNode());
      else
        return port.toString();
    } else if (obj instanceof JGoLabeledPart) {
      JGoLabeledPart part = (JGoLabeledPart)obj;
      return part.getText();
    } else if (obj instanceof JGoLink) {
      JGoLink link = (JGoLink)obj;
      return "link from " + ID(link.getFromPort().getParentNode()) + " to " + ID(link.getToPort().getParentNode());
    }
    return "";
  }

  public String RECT(Rectangle r) {
    return Integer.toString(r.x) + "," + Integer.toString(r.y) + "," + Integer.toString(r.width) + "," + Integer.toString(r.height);
  }

  private String myLogPrefix = "";
}
