/*
 *  Copyright (c) Northwoods Software Corporation, 2000-2008. All Rights
 *  Reserved.
 *
 *  Restricted Rights: Use, duplication, or disclosure by the U.S.
 *  Government is subject to restrictions as set forth in subparagraph
 *  (c) (1) (ii) of DFARS 252.227-7013, or in FAR 52.227-19, or in FAR
 *  52.227-14 Alt. III, as applicable.
 *
 */

package com.nwoods.jgo.examples.webdragdropeditor;

import java.awt.*;
import com.nwoods.jgo.*;
import com.nwoods.jgo.examples.*;
import com.nwoods.jgo.layout.*;

// This document class just provides some interesting behavior for this example
public class EditorImageDoc extends JGoDocument
{
  public String getName() { return myName; }
  public void setName(String s) { myName = s; }

  public int getViewCount() { return myViewCount; }
  public int getNextViewCount() { return ++myViewCount; }

  public EditorImageDoc()
  {
    super();
    setPaperColor(Color.yellow);
  }

  public EditorImageDoc copyDoc()
  {
      // create a new document
      EditorImageDoc doc = new EditorImageDoc();
      // copy all the document objects
      doc.copyFromCollection(this);
      // copy the document name
      doc.setName(this.getName());
      return doc;
  }

  // State
  private String myName = "";
  private int myViewCount = 0;
}
