/*
 *  Copyright (c) Northwoods Software Corporation, 2000-2008. All Rights
 *  Reserved.
 *
 *  Restricted Rights: Use, duplication, or disclosure by the U.S.
 *  Government is subject to restrictions as set forth in subparagraph
 *  (c) (1) (ii) of DFARS 252.227-7013, or in FAR 52.227-19, or in FAR
 *  52.227-14 Alt. III, as applicable.
 *
 */

package com.nwoods.jgo.examples.webdragdropeditor;

import java.awt.*;
import com.nwoods.jgo.*;
import com.nwoods.jgo.web.*;
import com.nwoods.jgo.examples.*;

// This view class just provides some interesting behavior for this example
public class EditorImageView extends JGoJPEGView
{
    public EditorImageView(EditorImageDoc doc)
    {
      super(doc);
      setIncludingNegativeCoords(true);

      // add a view-specific object to keep track of views
      int c = doc.getNextViewCount();
      if (doc.getName().length() > 0) {
        myComment = new Comment(doc.getName());
        myComment.setTopLeft(0, 0);
        addObjectAtTail(myComment);
      }
    }

    public void doBackgroundClick(int modifiers, Point dc, Point vc) {
      if (myPaletteView == null)
        return;
      JGoSelection sel = myPaletteView.getSelection();
      JGoObject selObject = sel.getPrimarySelection();
      if (selObject != null) {
        JGoObject dropObject = selObject.copy();
        dropObject.setLocation(dc);
        getDocument().add(dropObject);
      }
    }

    public String getCommentString()
    {
      if ((myComment == null) || (myComment.getLabel() == null))
        return "";
      else
        return myComment.getLabel().getText();
    }

    public void documentChanged(JGoDocumentEvent e) {
      switch (e.getHint()) {
        case JGoDocumentEvent.INSERTED:
          if (e.getJGoObject() instanceof JGoLink) {
            // Make sure all links have arrowheads
            JGoLink link = (JGoLink)e.getJGoObject();
            link.setArrowHeads(false, true);
          }
          if (e.getJGoObject() instanceof JGoBasicNode) {
            // When you add a node to the view, clear the selection in the palette
            // and select the object in the current view
            myPaletteView.getSelection().clearSelection();
            this.getSelection().selectObject(e.getJGoObject());
          }
      }
    }

    public void updateComment() {
      if (getDocument() == null)
        return;
      EditorImageDoc doc = (EditorImageDoc)getDocument();
      if (myComment == null) {
        myComment = new Comment(doc.getName());
        myComment.setTopLeft(0,0);
        addObjectAtTail(myComment);
      }
      else
        myComment.setText(doc.getName());
    }

    public void setPaletteView(JGoView paletteView) {
      myPaletteView = paletteView;
    }

    private Comment myComment = null;
    private JGoView myPaletteView = null;
}
