<html><head><title>WebDragDropEditor</title></head>
<%@ page import="java.awt.*" %>
<%@ page import="java.util.HashMap" %>
<%@ page import="java.util.Set" %>
<%@ page import="java.util.Iterator" %>
<%@ page import="java.lang.Math" %>
<%@ page import="com.nwoods.jgo.*" %>
<%@ page import="com.nwoods.jgo.web.*" %>
<%@ page import="com.nwoods.jgo.examples.webdragdropeditor.*" %>
<%
        /*
         * INITIALIZE THE JGOVIEW AND JGODOCUMENT OBJECTS
         */
        ServletContext context = getServletContext();
        // Create and initialize the Palette JGoDocument if
        // it doesn't already exist.
	JGoDocument palette = (JGoDocument)context.getAttribute("PaletteDoc");
	if (palette == null) {
            palette = new JGoDocument();
    	    JGoBasicNode node1 = new JGoBasicNode("Sample One");
            node1.setToolTipText("Sample tooltip one");
            node1.setLocation(50, 50);
	    node1.setBrush(new JGoBrush(Color.blue));
	    JGoBasicNode node2 = new JGoBasicNode("Sample Two");
            node2.setToolTipText("Sample tooltip two");
            node2.setLocation(50, 100);
	    node2.setBrush(new JGoBrush(Color.red));
	    JGoBasicNode node3 = new JGoBasicNode("Sample Three");
            node3.setToolTipText("Sample tooltip three");
            node3.setLocation(50, 150);
	    node3.setBrush(new JGoBrush(Color.green));
	    palette.addObjectAtTail(node1);
	    palette.addObjectAtTail(node2);
	    palette.addObjectAtTail(node3);
            palette.setModifiable(false);
            // Save the PaletteDoc in the ServletContext so we can share it
            // among different users.
            context.setAttribute("PaletteDoc", palette);
	}
        // If the PaletteView doesn't already exist, create it
        JGoJPEGView paletteView = (JGoJPEGView)session.getAttribute("PaletteView");
        if (paletteView == null)
            paletteView = new JGoJPEGView(palette);
        // Save the PaletteView in the Session so a single user can keep
        // any view attributes such as scrolling, zooming, and selection.
        session.setAttribute("PaletteView", paletteView);

        // Create the WorkAreaView and its JGoDocument (EditorImageDoc)
        // if it doesn't already exist
        EditorImageView workAreaView = (EditorImageView)session.getAttribute("WorkAreaView");
        if (workAreaView == null) {
            EditorImageDoc doc = new EditorImageDoc();
            doc.setDocumentSize(1200, 600);
            doc.setUndoManager(new JGoUndoManager());
            workAreaView = new EditorImageView(doc);
            workAreaView.setPaletteView(paletteView);
            session.setAttribute("WorkAreaView", workAreaView);
        }

        /*
         * PROCESS THE POSTBACK ARGUMENTS, IF ANY
         */
        String sView = request.getParameter("Target");
        // Update the JGoView objects
        if (sView != null) {
            JGoJPEGView view = (JGoJPEGView)session.getAttribute(sView);
            JGoImageEventProcessor myEventProcessor = new JGoImageEventProcessor();
            myEventProcessor.processEvents(request, view);
        }
        // Process "Open", "Save As", and "Delete" commands
        String sAction = "";
        if (request.getParameter("Action") != null)
            sAction = request.getParameter("Action");
        if (sAction.equals("OpenFile")) {
            String sOpenFileName = request.getParameter("OpenFileName");
            if ((sOpenFileName != null) && (sOpenFileName.length() > 0)) {
                HashMap savedDocumentNames = (HashMap)context.getAttribute("SavedDocumentNames");
                if (savedDocumentNames.get(sOpenFileName) != null) {
                    EditorImageDoc doc = (EditorImageDoc)savedDocumentNames.get(sOpenFileName);
                    workAreaView = new EditorImageView(doc.copyDoc());
                    int w = Math.max(workAreaView.getDocument().getDocumentSize().width, 1200);
                    int h = Math.max(workAreaView.getDocument().getDocumentSize().height, 600);
                    workAreaView.getDocument().setDocumentSize(w, h);
                    workAreaView.setPaletteView(paletteView);
                    session.setAttribute("WorkAreaView", workAreaView);
                }
            }
        }
        if (sAction.equals("SaveFileAs")) {
            String sSaveAsText = request.getParameter("SaveAsText");
            if ((sSaveAsText != null) && (sSaveAsText.length() > 0)) {
                HashMap savedDocumentNames = null;
                if (context.getAttribute("SavedDocumentNames") != null)
                    savedDocumentNames = (HashMap)context.getAttribute("SavedDocumentNames");
                else {
                    savedDocumentNames = new HashMap();
                    context.setAttribute("SavedDocumentNames", savedDocumentNames);
                }
                EditorImageDoc doc = (EditorImageDoc)workAreaView.getDocument();
                doc.setName(sSaveAsText);
                workAreaView.updateComment();
                savedDocumentNames.put(sSaveAsText, doc.copyDoc());
            }
        }
        if (sAction.equals("NewFile")) {
            EditorImageDoc doc = new EditorImageDoc();
            doc.setDocumentSize(1200, 600);
            workAreaView = new EditorImageView(doc);
            workAreaView.setPaletteView(paletteView);
            session.setAttribute("WorkAreaView", workAreaView);
        }
        if (sAction.equals("ZoomIn")) {
            workAreaView.setScale(workAreaView.getScale() * 1.5);
        }
        if (sAction.equals("ZoomOut")) {
            workAreaView.setScale(workAreaView.getScale() / 1.5);
        }
        if (sAction.equals("ZoomNormal")) {
            workAreaView.setScale(1);
        }
        if (sAction.equals("Cut")) {
            workAreaView.cut();
        }
        if (sAction.equals("Copy")) {
            workAreaView.copy();
        }
        if (sAction.equals("Paste")) {
            workAreaView.paste();
        }
        if (sAction.equals("Undo")) {
            EditorImageDoc doc = (EditorImageDoc)workAreaView.getDocument();
            doc.undo();
            workAreaView.getSelection().clearSelection();
        }
        if (sAction.equals("Redo")) {
            EditorImageDoc doc = (EditorImageDoc)workAreaView.getDocument();
            doc.redo();
        }

        // Modify the properties for the currently selected object in
        // the WorkAreaView
        String sLabelText = request.getParameter("LabelText");
        String sColors = request.getParameter("Colors");
        String labelText = "";
        String redChecked = "";
        String blueChecked = "";
        String greenChecked = "";
        String saveAsText = "";
        JGoSelection selection = workAreaView.getSelection();
        JGoObject selObj = selection.getPrimarySelection();
        if ((selObj != null) && (selObj instanceof JGoBasicNode)) {
            JGoBasicNode selNode = (JGoBasicNode)selObj;
            if (sAction.length() == 0) {
              if (sLabelText != null) {
                selNode.setText(sLabelText);
                selection.toggleSelection(selNode); // Force redraw of selection handle
                selection.toggleSelection(selNode); // to fit new text
              }
              if (sColors != null) {
                if (sColors.equals("red"))
                    selNode.setBrush(new JGoBrush(Color.red));
                else if (sColors.equals("blue"))
                    selNode.setBrush(new JGoBrush(Color.blue));
                else if (sColors.equals("green"))
                    selNode.setBrush(new JGoBrush(Color.green));
              }
            }
            labelText = selNode.getText();
            JGoBrush brush = selNode.getBrush();
            Color color = brush.getColor();
            if (color.getRGB() == Color.red.getRGB())
                redChecked = "checked";
            if (color.getRGB() == Color.blue.getRGB())
                blueChecked = "checked";
            if (color.getRGB() == Color.green.getRGB())
                greenChecked = "checked";
        }
        EditorImageDoc doc = (EditorImageDoc)workAreaView.getDocument();
        if (doc.getName() != null)
            saveAsText = doc.getName();

        HashMap savedDocumentNames = (HashMap)context.getAttribute("SavedDocumentNames");
        String sOpenControls = "";
        // Only show the "Open File" controls if there are any saved files
        if (savedDocumentNames != null) {
            sOpenControls = "<br>&nbsp;&nbsp;&nbsp;<input type=\"submit\" value=\"OpenFile\" name=\"Action\">"
              + "<select size=\"1\" name=\"OpenFileName\">";
            Set keySet = savedDocumentNames.keySet();
            for (Iterator it = keySet.iterator(); it.hasNext(); ) {
                String sDocName = (String)it.next();
                sOpenControls = sOpenControls + "<option>" + sDocName + "</option>" + "<br>";
            }
            sOpenControls = sOpenControls + "</select>";
        }

        // Get the current scaled size of the document
        JGoDocument workAreaDoc = workAreaView.getDocument();
        int nWorkAreaDocWidth = workAreaDoc.getDocumentSize().width;
        int nWorkAreaDocHeight = workAreaDoc.getDocumentSize().height;
        double dWorkAreaViewScale = workAreaView.getScale();
        String sWorkAreaW = Integer.toString((int)(nWorkAreaDocWidth * dWorkAreaViewScale));
        String sWorkAreaH = Integer.toString((int)(nWorkAreaDocHeight * dWorkAreaViewScale));

        // Create a unique id to add to <img> element to insure that old
        // cached images of the image are not used by the browser
        int uid = 0;
        String sUid = (String)session.getAttribute("Uid");
        if (sUid != null) {
          uid = Integer.parseInt(sUid) + 1;
        }
        session.setAttribute("Uid", Integer.toString(uid));
%>

<script language="JavaScript">
/*
 * Must include JGoWeb.js to process user interactions with diagram on browser
 */
<%@ include file="JGoWeb.js" %>

/*
 * Do a PostBack to the server.
 * This function is called by JGoWeb.js to postback to the server with
 * mouse events to redraw the diagram in response to standard user interaction
 * with the diagram (click, dbl-click, drag, etc.).  Note that if noPost is
 * TRUE when calling goInit (see <img> onLoad event) then __doPostBack is not
 * called and only the <img> is refreshed.
 */
function __doPostBack(eventTarget, eventArgument) {
    // The following code will updage the entire page
    saveScrollPos();
    <% String encodedURL = response.encodeURL("WebSample.jsp"); %>
    sURL = "<%= encodedURL %>" + "?Target=" + eventTarget + "&" + eventArgument
    window.location.assign(sURL);
}

var ZoomAction="None";
function saveScrollPos()
{
  var date = new Date();
  date.setTime(date.getTime()+(10*1000));
  var expires = "; expires="+date.toGMTString();
  var intX = document.getElementById("WorkAreaDiv").scrollLeft;
  var intY = document.getElementById("WorkAreaDiv").scrollTop;
  // The Zoom functions below zoom to the center of the current scrolled view.
  // (assumes 600x300 <div> element and multiplicative zoom factor of 1.5)
  if (ZoomAction == "ZoomIn")
    {
    intX = 1.5*(intX + 600/2) - 600/2;
    intY = 1.5*(intY + 300/2) - 300/2;
    }
  if (ZoomAction == "ZoomOut")
    {
    intX = 1/1.5*(intX + 600/2) - 600/2;
    intY = 1/1.5*(intY + 300/2) - 300/2;
    }
  if (ZoomAction == "ZoomNormal"){
    intX = 0;
    intY = 0;
    }
  document.cookie = "xPos="+intX+"endxPos"+expires+"; path=/";
  document.cookie = "yPos="+intY+"endyPos"+expires+"; path=/";
}

function restoreScrollPos()
{
    var strCook = document.cookie;
    var intS = strCook.indexOf("xPos=");
    var intE = strCook.indexOf("endxPos");
    var xPos = strCook.substring(intS + 5, intE);
    intS = strCook.indexOf("yPos=");
    intE = strCook.indexOf("endyPos");
    var yPos = strCook.substring(intS + 5, intE);
    document.getElementById("WorkAreaDiv").scrollLeft = xPos;
    document.getElementById("WorkAreaDiv").scrollTop = yPos;
}

function saveAndSubmit()
{
  saveScrollPos();
  myForm.submit();
}

// function to allow enter key in a text edit to submit the form
function enterSubmit(e, action)
{
var keynum;
var keychar;
var numcheck;

if (window.event)  // IE
  {
  keynum = e.keyCode;
  }
else if (w.which)  // Netscape/Firefox/Opera
  {
  keynum = e.which;
  }
if (keynum == 13)
  {
  document.myForm.Action.value = action;
  saveAndSubmit();
  return false;
  }
else
  return true;
}

</script>
<body onload="restoreScrollPos()">
<form name="myForm" method="POST" onsubmit="saveScrollPos()" action="WebSample.jsp">
<input type="button" name="JSPcode" value="View JSP code"
  onclick="saveScrollPos();window.location.href = 'ViewJSPCode.jsp'"><br>
<table border="1" width="721" id="table1" height="425">
  <tr>
  <td width="121" rowspan="2" valign="top">Palette<br>
  <img id="PaletteView" src="servlet/JGoImageServlet?GoView=PaletteView&width=121&height=300" width=121 height=300
    onmousedown="goMouseDown(event,'PaletteView')" onmouseup="goMouseUp(event,'PaletteView')"
    ondblclick="goDblClick(event,'PaletteView')"
    onmousemove="goMouseMove(event, 'PaletteView')"
    onload="jgoInit(
    'PaletteView',               // view name
    true,                        // noPost
    'servlet/JGoImageServlet')"  // image servlet page
  >
  </td>
  <td height="300" valign="top">View
  <div id="WorkAreaDiv" style="height:300px;width:600px;overflow:auto;position:relative;">
  <img id="WorkAreaView" src="servlet/JGoImageServlet?GoView=WorkAreaView&width=<%=sWorkAreaW%>&height=<%=sWorkAreaH%>&uid=<%=uid%>"
    width=<%=sWorkAreaW%> height=<%=sWorkAreaH%>
    onmousedown="goMouseDown(event,'WorkAreaView')" onmouseup="goMouseUp(event,'WorkAreaView')"
    ondblclick="goDblClick(event,'WorkAreaView')"
    onmousemove="goMouseMove(event, 'WorkAreaView')"
    onload="jgoInit(
    'WorkAreaView',              // view name
    false,                       // noPost
    'servlet/JGoImageServlet')"  // image servlet page
  >
  </div>
  </td>
  </tr>
  <tr>
  <td height="125" valign="top">
  Properties<br>&nbsp;&nbsp;
  Label: <input type="text" id="LabelText" name="LabelText" size="26"
    value="<%=labelText%>" onkeypress="return enterSubmit(event, '')">
  <br>&nbsp;&nbsp;
  Color:&nbsp;&nbsp;&nbsp;
  <input type="radio" name="Colors" <%=redChecked%> value="red" onClick="JavaScript:saveAndSubmit()">Red&nbsp;&nbsp;&nbsp;
  <input type="radio" name="Colors" <%=blueChecked%> value="blue" onClick="JavaScript:saveAndSubmit()">Blue&nbsp;&nbsp;&nbsp;
  <input type="radio" name="Colors" <%=greenChecked%> value="green" onClick="JavaScript:saveAndSubmit()">Green<br>
  </tr>
</table>
  &nbsp;
  <input type="submit" value="ZoomNormal" name="Action">
  <input type="submit" value="ZoomIn" name="Action" onClick="ZoomAction='ZoomIn'">
  <input type="submit" value="ZoomOut" name="Action" onClick="ZoomAction='ZoomOut'">
  <input type="submit" value="Cut" name="Action">
  <input type="submit" value="Copy" name="Action">
  <input type="submit" value="Paste" name="Action">
  <input type="submit" value="Undo" name="Action">
  <input type="submit" value="Redo" name="Action">
  <p>&nbsp;&nbsp;
  <input type="submit" value="SaveFileAs" name="Action">
  <input type="text" name="SaveAsText" size="20" value="<%=saveAsText%>"
    onkeypress="return enterSubmit(event, 'SaveFileAs')">
  <%=sOpenControls%>
  <br>&nbsp;&nbsp;
  <input type="submit" value="NewFile" name="Action">
  </p>
</form>
</body>
</html>