<html><head><title>WebUserGuideSample</title></head>
<%@ page import="java.awt.Color" %>
<%@ page import="com.nwoods.jgo.*" %>
<%@ page import="com.nwoods.jgo.web.*" %>
<%
        // Create and initialize the JGoJPEGView and its JGoDocument
        // if it doesn't already exist
        JGoJPEGView SampleView = (JGoJPEGView)session.getAttribute("SampleView");
        if (SampleView == null) {
          JGoDocument doc = new JGoDocument();
          doc.setPaperColor(Color.yellow);
          SampleView = new JGoJPEGView(doc);
          JGoBasicNode n1 = new JGoBasicNode("one");
          n1.setToolTipText("sample tooltip one");
          n1.setLocation(50, 50);
          doc.add(n1);
          JGoBasicNode n2 = new JGoBasicNode("two");
          n2.setToolTipText("sample tooltip two");
          n2.setLocation(100, 100);
          doc.add(n2);
          JGoLink l = new JGoLink(n1.getPort(), n2.getPort());
          doc.add(l);
          doc.setDocumentSize(1200, 600);
          doc.setUndoManager(new JGoUndoManager());
          session.setAttribute("SampleView", SampleView);
        }

        // Process the "Action" commands
        JGoDocument doc = SampleView.getDocument();
        String sAction = "";
        if (request.getParameter("Action") != null)
            sAction = request.getParameter("Action");
        if (sAction.equals("ZoomIn"))
            SampleView.setScale(SampleView.getScale() * 1.5);
        if (sAction.equals("ZoomOut"))
            SampleView.setScale(SampleView.getScale() / 1.5);
        if (sAction.equals("ZoomNormal"))
            SampleView.setScale(1);
        if (sAction.equals("Cut"))
            SampleView.cut();
        if (sAction.equals("Copy"))
            SampleView.copy();
        if (sAction.equals("Paste"))
            SampleView.paste();
        if (sAction.equals("Undo"))
            doc.undo();
        if (sAction.equals("Redo"))
            doc.redo();

        // Get the current scaled size of the document
        int nSampleDocWidth = doc.getDocumentSize().width;
        int nSampleDocHeight = doc.getDocumentSize().height;
        double dSampleViewScale = SampleView.getScale();
        String sSampleW = Integer.toString((int)(nSampleDocWidth * dSampleViewScale));
        String sSampleH = Integer.toString((int)(nSampleDocHeight * dSampleViewScale));

        // Create a unique id to add to <img> element to insure that old
        // cached images of the image are not used by the browser
        int uid = 0;
        String sUid = (String)session.getAttribute("Uid");
        if (sUid != null) {
          uid = Integer.parseInt(sUid) + 1;
        }
        session.setAttribute("Uid", Integer.toString(uid));
%>
<script language="JavaScript">
<%@ include file="JGoWeb.js" %>

var ZoomAction="None";
function saveScrollPos()
{
  var date = new Date();
  date.setTime(date.getTime()+(10*1000));
  var expires = "; expires="+date.toGMTString();
  var intX = document.getElementById("SampleDiv").scrollLeft;
  var intY = document.getElementById("SampleDiv").scrollTop;
  // The Zoom functions below zoom to the center of the current scrolled view.
  // (assumes 600x300 <div> element and multiplicative zoom factor of 1.5)
  if (ZoomAction == "ZoomIn") {
    intX = 1.5*(intX + 600/2) - 600/2;
    intY = 1.5*(intY + 300/2) - 300/2;
    }
  if (ZoomAction == "ZoomOut") {
    intX = 1/1.5*(intX + 600/2) - 600/2;
    intY = 1/1.5*(intY + 300/2) - 300/2;
    }
  if (ZoomAction == "ZoomNormal"){
    intX = 0;
    intY = 0;
    }
  document.cookie = "xPos="+intX+"endxPos"+expires+"; path=/";
  document.cookie = "yPos="+intY+"endyPos"+expires+"; path=/";
}

function restoreScrollPos()
{
    var strCook = document.cookie;
    var intS = strCook.indexOf("xPos=");
    var intE = strCook.indexOf("endxPos");
    var xPos = strCook.substring(intS + 5, intE);
    intS = strCook.indexOf("yPos=");
    intE = strCook.indexOf("endyPos");
    var yPos = strCook.substring(intS + 5, intE);
    document.getElementById("SampleDiv").scrollLeft = xPos;
    document.getElementById("SampleDiv").scrollTop = yPos;
}

</script>
<body onload="restoreScrollPos()">
<form name="myForm" method="POST" onsubmit="saveScrollPos()" action="WebSample.jsp">
<input type="button" name="JSPcode" value="View JSP code" onclick="saveScrollPos();window.location.href = 'ViewJSPCode.jsp'">
<div id="SampleDiv" style="height:300px;width:600px;overflow:auto;position:relative;">
<img id="SampleView"
  src="servlet/JGoImageServlet?GoView=SampleView&width=<%=sSampleW%>&height=<%=sSampleH%>&uid=<%=uid%>"
  width=<%=sSampleW%> height=<%=sSampleH%>
  onmousedown="goMouseDown(event, 'SampleView')"
  onmouseup="goMouseUp(event, 'SampleView')"
  ondblclick="goDblClick(event, 'SampleView')"
  onmousemove="goMouseMove(event, 'SampleView')"
  onload="jgoInit(
    'SampleView',                // view name
    true,                        // noPost
    'servlet/JGoImageServlet')"  // image servlet page
>
</div>
<input type="submit" name="Action" value="ZoomNormal" onClick="ZoomAction='ZoomNormal'">
<input type="submit" name="Action" value="ZoomIn" onClick="ZoomAction='ZoomIn'">
<input type="submit" name="Action" value="ZoomOut" onClick="ZoomAction='ZoomOut'">
<input type="submit" name="Action" value="Cut">
<input type="submit" name="Action" value="Paste">
<input type="submit" name="Action" value="Undo">
<input type="submit" name="Action" value="Redo">
</form>
</body>
</html>