/*
 *  Copyright (c) Northwoods Software Corporation, 1998-2008. All Rights
 *  Reserved.
 *
 *  Restricted Rights: Use, duplication, or disclosure by the U.S.
 *  Government is subject to restrictions as set forth in subparagraph
 *  (c) (1) (ii) of DFARS 252.227-7013, or in FAR 52.227-19, or in FAR
 *  52.227-14 Alt. III, as applicable.
 *
 */

package com.nwoods.jgo.examples.webwalker;

import java.util.Vector;
import java.io.*;
import java.net.*;

public class HTMLDoc
{
  public HTMLDoc(URL url)
  {
    myLinks = new Vector();
    myCurrentLink = 0;
    myURL = url;
  }

  public boolean loadPage()
  {
    BufferedReader stream;
    try {
      stream = new BufferedReader(new InputStreamReader(myURL.openStream()));
    } catch(MalformedURLException mue) {
      System.err.println("Error: Bad URL found " + myURL.toString());
      return false;
    } catch(IOException ioe) {
      System.err.println("Error: Could not open stream for " + myURL.toString());
      return false;
    }
    
    myText = "";
    
    // read all the characters in the file...
    try {
      while(true) {
        String line = stream.readLine();
        if(line == null) break;
        myText += line + '\n';
      }
    } catch(EOFException eof) {
      
    } catch(IOException ioe) {
      System.err.println("Error: Exception reading stream");
      return false;
    }
        
    return true;
  }
  
  public boolean parsePage()
  {
    String tag_str;
    int tag_loc, tag_end;

    tag_end = 0;
    while(true) {
      tag_loc = myText.indexOf('<', tag_end);
      if(tag_loc == -1) return true;

      tag_end = myText.indexOf('>', tag_loc);
      if(tag_end == -1) return false;

      tag_str = myText.substring(tag_loc + 1, tag_end);      
      Tag tag = new Tag(tag_str, myURL.toString());

      if(tag.isLink()) {
        myLinks.addElement(tag);
      }
    }
  }
  
  public int getNumLinks()
  {
    return myLinks.size();  
  }
  
  public boolean hasMoreLinks()
  {
    return (myCurrentLink < myLinks.size());
  }
  
  public String nextLink()
  {
    return ((Tag)myLinks.elementAt(myCurrentLink++)).getValue("HREF");        
  }


  protected URL myURL;
  protected String myText;
  protected Vector myLinks;
  protected int myCurrentLink;
}
