/*
 *  Copyright (c) Northwoods Software Corporation, 1998-2008. All Rights
 *  Reserved.
 *
 *  Restricted Rights: Use, duplication, or disclosure by the U.S.
 *  Government is subject to restrictions as set forth in subparagraph
 *  (c) (1) (ii) of DFARS 252.227-7013, or in FAR 52.227-19, or in FAR
 *  52.227-14 Alt. III, as applicable.
 *
 */

package com.nwoods.jgo.examples.webwalker;

import java.util.Vector;

public class Tag
{  
  /**
   * Create a new tag object from the given string.
   */
  public Tag(String str, String parent)
  {
    myProperties = new Vector();
    myValues = new Vector();
    myParent = parent;
    parseTag(str);
  }
  
  /**
   * Given a tag string we break it into name, and property/value
   * pairs.
   */
  protected void parseTag(String str)    
  // We use a FSM to parse the string.  
  {    
    String prop = "";
    String value = "";
    myName = "";
    
    str = str.trim();    
    int len = str.length();
    
    int state = StateNone;
    for(int p = 0; p < len; p++) {
      char ch = str.charAt(p);
      
      switch(state) {
      case StateNone:
        if(Character.isWhitespace(ch)) {
          state = StateWhiteSpace;
        } else if(ch != '<') {                  
          myName += ch;
        }
        break;
        
      case StateWhiteSpace:
        if(!Character.isWhitespace(ch)) {
          state = StateProp;          
          prop += ch;
        }
        break;
        
      case StateProp:
        if(ch == '=') {
          state = StateValue;          
        } else if(Character.isWhitespace(ch)
              || (ch == '>') || (p == len - 1)) {
          state = StateWhiteSpace;
          addProp(prop, "");
          prop = "";
        } else {
          prop += ch;  
        }
        break;
        
      case StateValue:
        if(Character.isWhitespace(ch)
            || ch == '>' || p == len - 1) {
          state = StateWhiteSpace;
          addProp(prop, value);
          prop = "";
          value = "";
        } else if(ch == '"') {
          state = StateValueString;          
        } else {
          value += ch;
        }
        break;
        
      case StateValueString:
        if(ch == '"') {
          state = StateWhiteSpace;
          addProp(prop,value);
          prop = "";
          value = "";
        } else {
          value += ch;
        }
        break;
      }
    }    
    myName = myName.toUpperCase().trim();
  }


  /**
   * Gets the value for the given property. If the property is
   * unknown, the empty string is returned.
   */
  public String getValue(String property)
  {
    int i;
    
    int len = myProperties.size();
    for(i = 0; i < len; i++) {
      String prop = (String)myProperties.elementAt(i);
      if(prop.equals(property)) break;
    }
    
    myLastFound = i;
    if(i >= len) return null;
    return (String)myValues.elementAt(i);
  }
  
  /**
   * Adds a property with the given value to the tag.
   */
  public void addProp(String p, String v)
  {
    if(getValue(p) == null) {
      myProperties.addElement(p.toUpperCase().trim());
      myValues.addElement(v);
    } else {
      myValues.setElementAt(v,myLastFound);  
    }
  }
  
  /**
   * Returns true if this tag represents a link.
   */
  public boolean isLink()
  {
    return (myName.equals("A"));  
  }


  /** the properties for this tag. */
  protected Vector myProperties;
  
  /** the values for the properties. */   
  protected Vector myValues;
  
  /** the name of the tag. */
  protected String myName;
  
  /** the page that contains this tag. */
  protected String myParent;
  
  /** the last index found when searching for a prop. value. */
  protected int myLastFound;

  private static final int StateNone = 0;
  private static final int StateProp = 1;
  private static final int StateWhiteSpace = 2;
  private static final int StateValue = 3;
  private static final int StateValueString = 4;
}
