/*
 *  Copyright (c) Northwoods Software Corporation, 1998-2008. All Rights
 *  Reserved.
 *
 *  Restricted Rights: Use, duplication, or disclosure by the U.S.
 *  Government is subject to restrictions as set forth in subparagraph
 *  (c) (1) (ii) of DFARS 252.227-7013, or in FAR 52.227-19, or in FAR
 *  52.227-14 Alt. III, as applicable.
 *
 */

package com.nwoods.jgo.examples.webwalker;

import java.awt.*;
import java.net.*;
import com.nwoods.jgo.*;

public class WebNode extends JGoNode
{

  public WebNode()
  {
    myToPort = null;
    myFromPort = null;
  }

  public JGoObject copyObject(JGoCopyEnvironment env)
  {
    WebNode newobj = (WebNode)super.copyObject(env);
    if (newobj != null) {
      newobj.myUserData = myUserData;
      newobj.myURL = myURL;
    }
    return newobj;
  }

  protected void copyChildren(JGoArea newarea, JGoCopyEnvironment env)
  {
    WebNode newobj = (WebNode)newarea;

    super.copyChildren(newarea, env);

    newobj.myToPort = (JGoPort)env.get(myToPort);
    newobj.myFromPort = (JGoPort)env.get(myFromPort);
  }

  public void initialize(Point loc2, Dimension size, JGoObject icon,
                         String label, URL url)
  {
    myURL = url;

    setResizable(false);

    myIcon = icon;
    myIcon.setBoundingRect(loc2,size);
    myIcon.setSelectable(false);
    addObjectAtHead(myIcon);

    Point botleft = myIcon.getSpotLocation(BottomLeft);
    myLabel = new JGoText(new Point(botleft.x,botleft.y-LABEL_OFFSET),label);
    myLabel.setSelectable(false);
    addObjectAtHead(myLabel);

    Point loc = myIcon.getSpotLocation(LeftCenter);
    myToPort = new JGoPort(new Rectangle(loc.x,loc.y,6,6));
    myToPort.setFromSpot(JGoObject.LeftCenter);
    addObjectAtTail(myToPort);

    loc = myIcon.getSpotLocation(RightCenter);
    myFromPort = new JGoPort(new Rectangle(loc.x,loc.y,6,6));
    myFromPort.setToSpot(JGoObject.RightCenter);
    addObjectAtTail(myFromPort);
  }

  public void layoutChildren(JGoObject childchanged)
  {
    if (isInitializing()) return;
    setInitializing(true);
    if (myLabel != null && myToPort != null && myFromPort != null) {
      myLabel.setSpotLocation(TopCenter, myIcon, BottomCenter);
      myToPort.setSpotLocation(Center, myIcon, LeftCenter);
      myFromPort.setSpotLocation(Center, myIcon, RightCenter);
    }
    setInitializing(false);
  }

  public boolean doMouseDblClick(int modifiers, Point dc, Point vc, JGoView view)
  {
    scanDoc(myURL, (WebView)view);
    return true;
  }

  protected void scanDoc(URL url, WebView view)
  {
    HTMLDoc doc = new HTMLDoc(url);

    Cursor oldcursor = view.getTopLevelAncestor().getCursor();
    view.getTopLevelAncestor().setCursor(new Cursor(Cursor.WAIT_CURSOR));

    if (doc.loadPage() && doc.parsePage()) {
      // caculate where to start putting new nodes
      Point spot = getSpotLocation(JGoObject.RightCenter);
      int xpos = spot.x + XINCREMENT;
      int ypos = Math.max(spot.y - ((doc.getNumLinks()*YINCREMENT)/2),5);

      // for all the links, add a new node
      while(doc.hasMoreLinks()) {
        String l = doc.nextLink();
        if (l != null) {
          try {
            URL newURL = new URL(myURL, l);  // handle relative URLs
             view.createNode(l, newURL, xpos, ypos, this);
          } catch (MalformedURLException mue) {
            // can't add a new node
          }
          ypos += YINCREMENT;
        }
      }
    }

    view.getTopLevelAncestor().setCursor(oldcursor);
  }

  protected static int YINCREMENT = 75;
  protected static int XINCREMENT = 75;


  public JGoPort getFromPort() {return myFromPort; }
  public JGoPort getToPort() { return myToPort; }

  protected static int LABEL_OFFSET = 20;

  protected Object myUserData = null;
  protected URL myURL;
  protected JGoText myLabel;
  protected JGoObject myIcon;
  protected JGoPort myToPort;
  protected JGoPort myFromPort;
}

