/*
 *  Copyright (c) Northwoods Software Corporation, 1998-2008. All Rights
 *  Reserved.
 *
 *  Restricted Rights: Use, duplication, or disclosure by the U.S.
 *  Government is subject to restrictions as set forth in subparagraph
 *  (c) (1) (ii) of DFARS 252.227-7013, or in FAR 52.227-19, or in FAR
 *  52.227-14 Alt. III, as applicable.
 *
 */

package com.nwoods.jgo.examples.webwalker;

import com.nwoods.jgo.*;
import java.awt.*;
import java.awt.event.*;
import java.net.*;

public class WebView extends JGoView
{
  public WebView() { super(); }

  protected WebNode createNode(String href, URL url, int xpos, int ypos, WebNode parent)
  {
    WebNode node = new WebNode();
    JGoRectangle rect = new JGoRectangle(new Rectangle(xpos,ypos,35,35));
    rect.setBrush(JGoBrush.make(JGoBrush.SOLID, Color.blue));

    if (url == null) {
      try {
        url = new URL(href);
      } catch (MalformedURLException x) {
        return null;
      }
    }

    node.initialize(new Point(xpos,ypos), new Dimension(35,35),
                    rect, href, url);

    node.setSpotLocation(JGoObject.TopCenter, xpos, ypos);

    getDocument().addObjectAtHead(node);

    if (parent != null) {
      JGoLink link = new JGoLink(parent.getFromPort(),node.getToPort());
      link.setSelectable(false);
      getDocument().addObjectAtHead(link);
    }

    return node;
  }

  // handle the Delete key as well as the page up/down keys
  public void onKeyEvent(KeyEvent evt)
  {
    int t = evt.getKeyCode();
    if (t == KeyEvent.VK_DELETE)
      deleteSelection();
    else
      super.onKeyEvent(evt);
  }
}
