/*
 *  Copyright (c) Northwoods Software Corporation, 1998-2008. All Rights
 *  Reserved.
 *
 *  Restricted Rights: Use, duplication, or disclosure by the U.S.
 *  Government is subject to restrictions as set forth in subparagraph
 *  (c) (1) (ii) of DFARS 252.227-7013, or in FAR 52.227-19, or in FAR
 *  52.227-14 Alt. III, as applicable.
 *
 */

package com.nwoods.jgo.examples.webwalker;

import java.applet.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import com.nwoods.jgo.*;
import com.nwoods.jgo.examples.SimpleNode;


public class WebWalker extends JApplet implements Runnable
{
  protected JTextField myBaseURLField;
  protected WebView myView;
  protected JGoDocument myDocument;

  public WebWalker()
  {
    Container contentPane = getContentPane();
    contentPane.setLayout(new BorderLayout());

    myBaseURLField = new JTextField(20);

    JPanel top = new JPanel();
    top.setLayout(new FlowLayout());
    top.add(new JLabel("Base URL: "));
    top.add(myBaseURLField);
    JButton ScanButton = new JButton("Scan");
    top.add(ScanButton);

    ScanButton.addActionListener(
      new java.awt.event.ActionListener()
        {
          public void actionPerformed(ActionEvent e)
          {
             WebNode parentObj = myView.createNode(myBaseURLField.getText(),null,10,200,null);
          }
        }
    );

    myBaseURLField.addActionListener(
      new java.awt.event.ActionListener()
        {
          public void actionPerformed(ActionEvent e)
          {
             WebNode parentObj = myView.createNode(myBaseURLField.getText(),null,10,200,null);
          }
        }
    );

    myView = new WebView();
    myView.setSecondarySelectionColor(myView.getPrimarySelectionColor());
    myDocument = myView.getDocument();

    contentPane.add(top, BorderLayout.NORTH);
    contentPane.add(myView, BorderLayout.CENTER);
  }

  public void start()
  {
    // enable drag-and-drop from separate thread
    new Thread(this).start();
  }

  public void run() {
    myView.initializeDragDropHandling();
  }

  public static void main(String[] args)
  {
    try {
      final JFrame mainFrame = new JFrame();

      // close the application when the main window closes
      mainFrame.addWindowListener(new WindowAdapter() {
        public void windowClosing(java.awt.event.WindowEvent event) {
          Object object = event.getSource();
          if (object == mainFrame)
            System.exit(0);
        }
      });

      mainFrame.setTitle("WebWalker JGo Application");
      Dimension screensize = Toolkit.getDefaultToolkit().getScreenSize();
      mainFrame.setBounds(0, 0, screensize.width, screensize.height);

      WebWalker app = new WebWalker();
      Container contentPane = mainFrame.getContentPane();
      contentPane.setLayout(new BorderLayout());
      contentPane.add(app, BorderLayout.CENTER);
      contentPane.validate();

      mainFrame.setVisible(true);

      app.init();
      app.start();
    } catch (Throwable t) {
      System.err.println(t);
      t.printStackTrace();
      System.exit(1);
    }
  }
}
